
/*
	STRING.CPP
	Created 1995 by Dejvid Zaninovic
*/

#include <string.h>
#include <mem.h>
#include <alloc.h>
#include "string.hpp"


/*
	char *strror (char *s)

	- rotate string right
*/

char *strror (char *s)
{
	char o;
	word len;

	len = strlen (s);
	memror ((byte *) s, len);

	return s;
}


/*
	char *strrol (char *s)
	
	- rotate string left
*/

char *strrol (char *s)
{
	char o;
	word len;

	len = strlen (s);
	memrol ((byte *) s, len);

	return s;
}


/*
	char *strshr (char *s)
	
	- shift string right
*/

char *strshr (char *s)
{
	word len;

	len = strlen (s);
	memshr ((byte *) s, len);

	return s;
}


/*
	char *strshl (char *s)
	
	- shift string left
*/

char *strshl (char *s)
{
	word len;

	len = strlen (s);
	memshl ((byte *) s, len);

	return s;
}


/*
	boolean isblank (const char *s)

	- is string blank
*/

boolean isblank (const char *s)
{
	word a;

	for (a=0; s[a] == ' '; a++);
	if (s[a] == 0)
		return TRUE;
	return FALSE;
}


/*
	char *strchg (char *s, const char *o, const char *n)

	- search string o in string s and replace with string n
*/

char *strchg (char *s, const char *o, const char *n)
{
	char *tmp;
	char *f;
	word it, is;

	tmp = (char *) malloc (strlen (s));
	f = s;
	it = is = 0;
	do {
		f = strstr (f, o);
		if (f == NULL)
			break;
		for (; s+is != f; is++, it++)
			tmp[it] = s[is];
		strcpy (tmp+it, n);
		f += strlen (o);
		is += strlen (o);
		it += strlen (n);
	} while (TRUE);
	strcpy (tmp+it, s+is);
	strcpy (s, tmp);
	free (tmp);
	return s;
}


/*
	char *stralltrim (char *s)
	
	- trim leading and trailing blanks from string
*/

char *stralltrim (char *s)
{
	return strrtrim (strltrim (s));
}


/*
	char *strrtrim (char *s)

	- trim trailing blanks
*/

char *strrtrim (char *s)
{
	word a;

	for (a=strlen(s)-1; s[a]==' '; a--);
	s[a+1] = 0;

	return s;
}


/*
	char *strltrim (char *s)
	
	- trim leading blanks
*/

char *strltrim (char *s)
{
	word a;

	for (a=0; s[a] == ' '; a++);
	strcpy (s, s+a);

	return s;
}


/*
	char *strrem (char *s)
	
	- remove trailing remark which begin with ';'
*/

char *strrem (char *s)
{
	char *f;

	f = strchr (s, ';');
	*f = 0;
	return s;
}


/*
	char *skipb (const char *s)
	
	- skip blank characters
*/

char *skipb (const char *s)
{
	for (; *s == ' '; s++);
	return (char *) s;
}


/*
	boolean strwild (const char *s, const char *w)
	
	- is string s equal to wildcard string	
*/

boolean strwild (const char *s, const char *w)
{
	boolean done, done2, ret;
	char f [100];
	int a;

	done = ret = FALSE;
	do {
		switch (*w) {
		case '*':
			done2 = FALSE;
			do {
				if ((*w != '*') && (*w != '?')) {
					done2 = TRUE;
					break;
				}
				w++;
			} while (!done2);
			a = 0;
			done2 = FALSE;
			do {
				if ((*w == '*') || (*w == '?') || (*w == 0)) {
					done2 = TRUE;
					break;
				}
				f [a++] = *w;
				w++;
			} while (!done2);
			f [a] = 0;
			s = strsfrag (s, f);
			if (s == NULL)
				done = TRUE;
			break;              
		case '?':
			if (*s == 0) {
				done = TRUE;
				break;
			}
			s++;
			w++;
			break;
		case 0:
			if (*s == *w) 
				ret = TRUE;
			done = TRUE;
			break;
		default:
			if (*s != *w) {
				done = TRUE;
				break;
			}
			s++;
			w++;
		}
	} while (!done);
	return ret;
}


/*
	word chksum (const char *s);		

	- return checksum of buf
*/

word chksum (const char *s)
{
	word a=0;
	word sum=0;

	while (s [a] != 0)
		sum += s [a++];
										
	return sum;
}


/*
	boolean strin (char c, const char *s)
	
	- is char c in string s
*/

boolean strin (char c, const char *s)
{
	for (; *s != NULL; s++) {
		if (*s == c)
			return TRUE;
	}
	return FALSE;
}


/*
	char *strsfrag (const char *s, const char *f)

	- return fragment of string s occuring after string f
*/

char *strsfrag (const char *s, const char *f)
{
	const char *ret;
	const char *f0;
	boolean done;

	if (*f == 0) {
		s += strlen (s);
		return (char *) s;
	}
	f0 = f;
	ret = NULL;
	done = FALSE;
	do {
		if (*s == *f)
			f++;
		else
			f = f0;
		if (*f == 0) {
			done = TRUE;
			ret = s + 1;
			break;
		}			
		if (*s == 0) {
			done = TRUE;
			ret = NULL;
			break;
		}
		s++;
	} while (!done);

	return (char *) ret;
}


/*
	byte *memror (byte *m, word len)

	- rotate memory right
*/

byte *memror (byte *m, word len)
{
	byte o;

	if (len > 0) {
		o = m [len-1];
		movmem (m, m+1, len-1);
		m [0] = o;
	}

	return m;
}


/*
	byte *memrol (byte *m, word len)

	- rotate memory left
*/

byte *memrol (byte *m, word len)
{
	byte o;

	if (len > 0) {
		o = m [0];
		movmem (m+1, m, len-1);
		m [len-1] = o;
	}

	return m;
}


/*
	byte *memshr (byte *m, word len)

	- shift memory right
*/

byte *memshr (byte *m, word len)
{
	if (len > 0) {
		movmem (m, m+1, len-1);
		m[0] = 0;
	}

	return m;
}


/*
	byte *memshl (byte *m, word len)

	- shift memory left
*/

byte *memshl (byte *m, word len)
{
	if (len > 0) {
		movmem (m+1, m, len-1);
		m [len-1] = 0;
	}

	return m;
}
