
;
;	XMS.ASM
;	Created 1995 by Dejvid Zaninovic
;

IDEAL
INCLUDE "ASM.INC"

EXTRN PROLOG @bcdtoi$qi:PROC

PUBLIC xms_driver, xms_inited, xms_error

PUBLIC xms_init, xms_version, xms_revision, xms_ishma, xms_allochma
PUBLIC xms_freehma, xms_genable20, xms_gdisable20, xms_lenable20
PUBLIC xms_ldisable20, xms_query20, xms_coreleft, xms_totmem, xms_alloc
PUBLIC xms_free, xms_copy, xms_lock, xms_unlock, xms_locks, xms_freehandles
PUBLIC xms_getlen, xms_realloc, xms_allocumb, xms_freeumb

STRUC			s_xms_copy
len				DD		?
shandle			DW		?
soff			DD		?
dhandle			DW		?
doff			DD		?
ENDS

XE_NOERR		EQU		0		; no error
XE_NODRVR		EQU		1		; no XMS driver

CODESEG

xms_driver		DD		?
xms_inited		DW		FALSE
xms_error		DB		0
xms_copy_s 		s_xms_copy	?

;
;	boolean xms_init (void)
;
;   - init XMS
;	- return TRUE if XMS installed
;

PROC 		xms_init 
			
			MOV AX,4300
			INT 2F
			CMP AL,80
			JE @@J1
			MOV AX,FALSE
			MOV [CS:xms_error],XE_NODRVR
			JMP @@exit
@@J1:	
			MOV AX,4310
			INT 2F
			MOV [WORD CS:xms_driver],BX		
			MOV [WORD CS:xms_driver+2],ES
			MOV AX,TRUE
			MOV [CS:xms_inited],TRUE
			MOV [CS:xms_error],XE_NOERR
@@exit:
			RET
ENDP

;
;	word xms_version();
;
;	- return XMS version * 100
;

PROC		xms_version 

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0
			CALL [CS:xms_driver]
			MOV [CS:xms_error],XE_NOERR

			PUSH AX
			CALL @bcdtoi$qi
			INC SP
			INC SP
@@exit:
			RET
ENDP

;
;	word xms_revision();
;
;	- return XMS revision * 100
;

PROC		xms_revision

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0
			CALL [CS:xms_driver]
			MOV [CS:xms_error],XE_NOERR

			PUSH BX
			CALL @bcdtoi$qi
			INC SP
			INC SP
@@exit:
			RET
ENDP

;
;	boolean xms_ishma();
;
;	- return TRUE if HMA exist 
;

PROC		xms_ishma

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0
			CALL [CS:xms_driver]
			MOV [CS:xms_error],XE_NOERR
			MOV AX,DX
@@exit:
			RET
ENDP

;
;	boolean xms_allochma (unsigned n);
;
;	- alloc n bytes of HMA
;	- return TRUE if ok 
;

PROC		xms_allochma
ARG			n

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,1
			MOV DX,[n]
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	boolean xms_freehma();
;
;	- free all HMA
;	- return TRUE if ok 
;

PROC		xms_freehma

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,2
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	boolean xms_genable20();
;
;	- global enable A20 line
;	- return TRUE if ok 
;

PROC		xms_genable20

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,3
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	boolean xms_gdisable20();
;
;	- global disable A20 line
;	- return TRUE if ok 
;

PROC		xms_gdisable20

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,4
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	boolean xms_lenable20();
;
;	- local enable A20 line
;	- return TRUE if ok 
;

PROC		xms_lenable20

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,5
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	boolean xms_ldisable20();
;
;	- local disable A20 line
;	- return TRUE if ok 
;

PROC		xms_ldisable20

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,6
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	boolean xms_query20();
;
;	- query A20 line
;	- return TRUE if enabled 
;

PROC		xms_query20

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,7
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	word xms_totmem();
;
;	- return free XMS KB
;

PROC		xms_totmem

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,8
			CALL [CS:xms_driver]
			MOV AX,DX
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	word xms_coreleft();
;
;	- return largest free XMS block in KB
;

PROC		xms_coreleft

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,8
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;                       
;	boolean xms_alloc (word size, word far *handle);
;
;	- alloc size KB of XMS
;	- return TRUE if ok
;

PROC		xms_alloc
USES		DI
ARG			s, handle:FAR PTR WORD

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,9
			MOV DX,[s]
			CALL [CS:xms_driver]
			LES DI,[handle]
			MOV [ES:DI],DX
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;                       
;	boolean xms_free (word handle);
;
;	- free EMB
;	- return TRUE if ok
;

PROC		xms_free
ARG			handle

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0A
			MOV DX,[handle]
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;                       
;	boolean xms_copy (dword len, word shandle, dword soff,
;		word dhandle, dword doff);
;
;	- copy len bytes from shandle:soff to dhandle:doff
;	- if handle == 0 then off = seg:off
;	- return TRUE if ok
;

PROC		xms_copy
USES		SI, DS
ARG			len:DWORD, shandle, soff:DWORD, dhandle, doff:DWORD

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0Bh
			MOV SI,CS
			MOV DS,SI
			MOV SI,OFFSET xms_copy_s

			MOV AX,[WORD len]
			MOV [WORD xms_copy_s.len],AX
			MOV AX,[WORD len+2]
			MOV [WORD (xms_copy_s.len)+2],AX

			MOV AX,[shandle]
			MOV [xms_copy_s.shandle],AX

			MOV AX,[WORD soff]
			MOV [WORD xms_copy_s.soff],AX
			MOV AX,[WORD soff+2]
			MOV [WORD (xms_copy_s.soff)+2],AX

			MOV AX,[dhandle]
			MOV [xms_copy_s.dhandle],AX

			MOV AX,[WORD doff]
			MOV [WORD xms_copy_s.doff],AX
			MOV AX,[WORD doff+2]
			MOV [WORD (xms_copy_s.doff)+2],AX

			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	void far *xms_lock (word handle);
;
;	- lock EMB, get absolute adress of block
;	- return NULL if not ok
;

PROC		xms_lock
ARG			handle

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0C
			MOV DX,[handle]
			CALL [CS:xms_driver]
			OR AX,AX
			JNZ @@J2
			XOR AX,AX
			CWD
			JMP @@J3
@@J2:
			MOV AX,BX
@@J3:
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	boolean xms_unlock (word handle);
;
;	- unlock EMB
;	- return TRUE if ok
;

PROC		xms_unlock
ARG			handle

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0Dh
			MOV DX,[handle]
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	int xms_locks();
;
;	- get number of locked block's
;	- return -1 if error
;

PROC		xms_locks

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0Dh
			CALL [CS:xms_driver]
			OR AX,AX
			JNZ @@J2
			MOV [CS:xms_error],BL
			MOV AX,-1
			JMP @@exit
@@J2:
			MOV AL,BH
			XOR AH,AH
			MOV [CS:xms_error],XE_NOERR
@@exit:
			RET
ENDP

;
;	int xms_freehandles();
;
;	- get number of free handles in the system
;	- return -1 if error
;

PROC		xms_freehandles

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0Dh
			CALL [CS:xms_driver]
			OR AX,AX
			JNZ @@J2
			MOV [CS:xms_error],BL
			MOV AX,-1
			JMP @@exit
@@J2:
			MOV AL,BL
			XOR AH,AH
			MOV [CS:xms_error],XE_NOERR
@@exit:
			RET
ENDP

;
;	word xms_getlen (word handle);
;
;	- get block len in KB
;	- return FALSE if not ok
;

PROC		xms_getlen
ARG			handle

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0Dh
			MOV DX,[handle]
			CALL [CS:xms_driver]
			OR AX,AX
			JNZ @@J2
			MOV [CS:xms_error],BL
			XOR AX,AX
			JMP @@exit
@@J2:
			MOV AX,DX
			MOV [CS:xms_error],XE_NOERR
@@exit:
			RET
ENDP

;                       
;	boolean xms_realloc (word size, word handle);
;
;	- realloc handle to size KB
;	- return TRUE if ok
;

PROC		xms_realloc
ARG			s, handle

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,0F
			MOV BX,[s]
			MOV DX,[handle]
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	void far *xms_allocumb (word n);
;
;	- alloc n paragraphs of UMB
;	- return far ptr to allocated block
;	- return NULL if not ok
;

PROC		xms_allocumb
ARG			n

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,10
			MOV DX,[n]
			CALL [CS:xms_driver]
			OR AX,AX
			JNZ @@J2
			CWD
			JMP @@J3
@@J2:
			MOV DX,BX
			XOR AX,AX
@@J3:
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

;
;	boolean xms_freeumb (void far *mem);
;
;	- free UMB block
;	- return TRUE if ok
;

PROC		xms_freeumb
ARG			mem:FAR PTR DWORD

			CMP [CS:xms_inited],TRUE
			JE @@J1
			CALL xms_init
			CMP AL,TRUE
			JE @@J1
			JMP @@exit
@@J1:		
			MOV AH,11
			MOV DX,[WORD mem+2]
			CALL [CS:xms_driver]
			MOV [CS:xms_error],BL
@@exit:
			RET
ENDP

END
