/* BIOSKEYX.C: Reading the enhanced keyboard's F11 & F12 keys

	 The bioskey() example can be modified to recognize the F11 and F12
	 extended keys. This requires the use of functions 16 and 17; function
	 17 (0x11) gets an enhanced keyboard's status and function 16 (0x10)
	 reads a character from an enhanced keyboard.

	 NOTE:  Requires enhanced keyboard and corresponding BIOS
*/

#include <stdio.h>		// for printf()
#include <bios.h>			// for bioskey()
#include <ctype.h>		// for isalnum()

#define RIGHT  0x01
#define LEFT   0x02
#define CTRL   0x04
#define ALT    0x08

//*******************************************************************
int main(void)
{
	int key, modifiers;

	// function 17 returns 0 until a key is pressed
	while (bioskey(17) == 0);

	// function 16 returns the key that is waiting
	key = bioskey(16);

	// use function 2 to determine if shift keys were used
	modifiers = bioskey(2);
	if (modifiers) {
		printf("[");
		if (modifiers & RIGHT) printf("RIGHT");
		if (modifiers & LEFT)  printf("LEFT");
		if (modifiers & CTRL)  printf("CTRL");
		if (modifiers & ALT)   printf("ALT");
		printf("]");
	}

	// print out the character read
	if (isalnum(key & 0xFF))
		printf("'%c'\n", key);
	else
		printf("%#02x\n", key);

	return 0;
} // end of main()
