/* C.C: Member Data Initialization Using Constructor Initialization List

	 The following code demonstrates the initialization of a class's
	 member data by using the initialization list of a class constructor.
	 It also shows how to call a base class constructor from a derived
	 class.

	 Since this code uses floating point, be sure to have floating
	 point emulations enabled (IDE) or include EMU.LIB and MATHx.LIB at
	 the appropriate location in the TLINK command line.
*/

#include <iostream.h>

#define HUND 100

class base {
	public:
		base() { cout << "in base\n"; }
};

class derive : public base {
		int x, z;
		float y;

	public:
		/* Note that the initialization list comes AFTER the contructors
			 formal arguments and a colon. Each variable name is followed
			 by an initial value in parenthese. Each variable is separated
			 from the next by a comma.  The value in the parenthese can
			 be either a variable from the constructor parameter list,
			 a value, an expression that results in a value, or a constant.

			 At the end of the initialization list is the call to the base
			 class constructor.  In this example, parameters are not passed,
			 however, parameters may be passed and they may consist of a
			 variable from the derived constructor parameter list, a value,
			 an expression that results in a value, or a constant.

			 A private or public member of the base class cannot be
			 initialized by the initialization list of the derived
			 constructor. */

		//initialization list...Call to base constructor
		derive(int a) : x(a*a), z(HUND), y(4.33), base() {
			cout << "in derive\n";
		}

		void show(void) {
			cout << "x is " << x;
			cout << "\nz is " << z;
			cout << "\ny is " << y;
		}
};

//*******************************************************************
int main()
{
	derive dd(3);
	dd.show();
	return 0;
} // end of main()
