/* CINCOUTD.CPP: Redirecting CIN or COUT.

		 In the following program, the input with CIN can be redirected
		 to gather the data from a file, or the output with COUT can be
		 redirected to a file or stdprn depending on the program's
		 command line arguments.
*/

#include <fstream.h>
#include <iostream.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <string.h>
#include <sys\stat.h>

#define  PRNHANDLE  4
#define  ARRAYSIZE  80

void OutputUsage( void );
int  OpenOutFile( char * );
int  OpenInFile( char * );

int main( int argc, char *argv[] )
{
		char      io = 0;             //Keeps track if CIN or COUT redirection
		filebuf   *fBuf;              //Filebuf created with stdprn filehandle
		streambuf *oldBuf;            //Used to hold the old streambuf while CIN
																	//  or COUT is being redirected
        unsigned  fhndl = -1;         //File handle of redirected file
		char      a[ARRAYSIZE + 1];   //Used for the sample I/O

        if ( argc != 2 ) {
			switch( argv[1][0] ) {      //Check the second command argument

			// Redirect CIN to gather from file specified at
			// command line
				case 'I':
				case 'i':

					// Capture CIN's current streambuf before it is reassigned
					oldBuf = cin.rdbuf();
					io = 'i';

					// Opens file specified at command line and redirects
					// CIN to extract from it
					fhndl = OpenInFile( argv[2] );
					break;

				// Redirect COUT to output to file specified
				// at the command line
				case 'O':
				case 'o':

					// Capture COUT's streambuf before new
					// streambuf * is assigned.
					oldBuf = cout.rdbuf();
					io = 'o';

					// Opens file specified at command line and
					// redirects output via COUT to file
					fhndl = OpenOutFile( argv[2] );
					break;

				// Redirect COUT to stdprn
				case 'P':
				case 'p':

					// Create a new filebuf with the file handle to stdprn
					fBuf = new filebuf( PRNHANDLE );

					// Use overloaded assignment operator to assign
					// new filebuf to COUT
					cout = fBuf;
					break;
				default:

					// If no command line arguments specified, use
					// default settings for CIN and COUT
					if ( argc == 1 ) {
						break;
					}
					// Output command line usage if 2nd command
					// line argument incorrect
					OutputUsage();
				}
		}

		// NOW NORMAL USE OF CIN AND COUT WILL HONOR ANY
		// REDIRECTION DONE ABOVE

		// Simple demonstration of CIN inserting characters
		// into array 'a'
		cin.getline( a, ARRAYSIZE );

		// Check to make sure the previous function call did
		// not produce errors
		if( cin.fail() ) {
			return 1;
		}

		// Simple demonstration of COUT outputting contents
		// of 'a' to output stream
		cout << a << endl;

		// If a file was opened for redirection, close that file
		if ( fhndl != -1 ) {
				close( fhndl );

			// Reassign the old streambuf * to either CIN or COUT
			if ( io == 'i' ) {
				cin = oldBuf;
			}
			else
				if ( io == 'o' ) {
					cout = oldBuf;
				}
			// NOW CIN AND COUT HAVE BEEN SET TO ORIGINAL STATE
		}
		return 0;
}

int OpenOutFile( char *filename ) {
	filebuf *tmpFBuf;
	int fhndl;
	fhndl = open( filename, O_CREAT|O_TEXT|O_RDWR, S_IREAD|S_IWRITE );
	if ( fhndl == -1 ) {
		cout << "Error opening file " << filename << ", program terminated.";
		cout << endl;
		exit(1);
	}

	// Create new filebuf with file handle of file specified
	// at command line
	tmpFBuf = new filebuf( fhndl );

	// Use overloaded assignment operator to assign new
	// filebuf to COUT
	cout = tmpFBuf;
	return fhndl;
}

int OpenInFile( char *filename ) {
	filebuf *tmpFBuf;
	int fhndl;
	fhndl = open( filename, O_CREAT|O_TEXT|O_RDONLY, S_IREAD|S_IWRITE );
	if ( fhndl == -1 ) {
		cout << "Error opening file " << filename << ", program terminated.";
		cout << endl;
		exit(1);
	}

	// Create new filebuf with file handle of file specified at command line
	tmpFBuf = new filebuf( fhndl );

	// Use overloaded assignment operator to assign new filebuf to CIN
	cin = tmpFBuf;
	return fhndl;
}

void OutputUsage( void ) {
	cout << endl << "Usage: <exe filename> [I, O, ?, h] <filename>" << endl;
	cout << "I - cin will be redirected to input from  <filename>." << endl;
	cout << "O - cout will be redirected to output to <filename>." << endl;
	cout << "P - cout will be redirected to output to stdprn." << endl;
	cout << "? or h - Outputs this screen." << endl;
}
