/* NU.CPP: Demo of using pre-allocated memory with new

		This code demonstrates how to overload new overload new to use
		a pre-allocated block of memory for a class.
*/

#include <iostream.h>
#include <new.h>

class A {
	public:
		void * operator new(size_t size);
		void * operator new(size_t size, void *ptr);
};

/*-------------------------------------------------------------------
		Overload new to allocate a block of
		memory of specified size of class.
*/

void * A::operator new(size_t size)
{
	void *ptr;
	ptr=new unsigned char[size];
	return ptr;
}

/*-------------------------------------------------------------------
    Overload new to accept a pre-allocated
		pointer to a block of memory for a class.
*/

void * A::operator new(size_t size, void *ptr)
{
#pragma warn -par					// we know size is never used!
	cout << "new block\n";
  return ptr;
}

//*******************************************************************
int main()
{
#pragma warn -aus				// we know ch & y are assigned unused values!
	// Pre-allocate a block of memory
  void * buf=new (unsigned char[sizeof(A)]);

  cout << "before new\n";
  
  A *y;                 // Assign pre-allocated block of
  y=new(buf) A;         // memory to a pointer of class A.

	A *ch;                // Allocate and assign a block of
	ch=new A;             // memory to a pointer of class A.
	return 0;
} // end of main
