/* OBRACK.CPP: Overloading Bracket Operator for Array Range Checking
*/

#include <stdio.h>			// for fprintf() and stderr
#include <stdlib.h>			// for exit()
#include <conio.h>			// for clrscr()

#define size 10

class array{
		int index;
		unsigned linear[size];
		void error(char * msg);
	public:
		array(unsigned value = 0);
		unsigned & operator[](int index);
};

void array::error(char *msg) {
	fprintf(stderr, "Array Error: %s\n", msg);
}

array::array(unsigned value) {
	for (int i = 0; i < size; i++)
		linear[i] = value;
}

unsigned & array::operator[](int index) {
	char msg[30];
	if (index < 0 ) {
		sprintf(msg, "array index must be >= 0.");
		error(msg);
	}
	if (index >= size) {
		sprintf(msg, "array index must be < %d.", size);
		error(msg);
	}
	return linear[index];
}

//*******************************************************************
int main()
{
	clrscr();
	array a(0);				// create array of 10 elements and init to 0
	a[0] = 5;					// ok because 0 >= 5 < 10
	a[100] = 10;			// Array Error: "array index must be < 10."
	a[-1] = 15;				// Array Error: "array index must be >= 0."
	return 0;
} // end of main()
