/* PSP.C: How to Get the Name of a Spawned Program's Parent */

#include <stdio.h>        // for putchar()
#include <dos.h>          // for MK_FP

typedef unsigned SEG;

extern SEG _psp;

//*******************************************************************int main (void) {
  SEG far * pspparent;    // Segment of parent PSP
  SEG far * envparent;    // Segment of parent environment
  char far *who;          // Char ptr to name of parent process

  // Get segment and environment of parent PSP
  pspparent = (SEG far*)MK_FP (_psp, 0x16);
  envparent = (SEG far*)MK_FP (*pspparent, 0x2C);

  // Initialize parent process name pointer
  who = (char far*)MK_FP (*envparent, 0x00);

  // Find the end of the environment. The environment is terminated
  // by two '\0' characters

  while (!((who [0] == '\0') && (who [1] == '\0'))) who++;

  // Point at the parent process name and display it. 
  who += 4;
  while (who [0] != '\0') putchar (*who++);
  return 0; }  // end of main()
