/* REBOOT.C:  If given a command line argument of /w the program
							will only warm boot the CPU.  All other command line
							arguments are ignored.  If the /w argument is not
							specified the cpu will be cold booted.
*/

#include <dos.h>                    // MK_FP()
#include <stdio.h>                  // printf()
#include <conio.h>                  // getch()
#include <string.h>                 // strcmp()

//*******************************************************************
#pragma warn -par   							  // we know argc is nver used!
int main(int argc, char *argv[])
{
	typedef void (far *reboot)(void); // Function pointer.
	unsigned far *warmpt;             // Absolute pointer.
	int warmfl;                       // Warm boot flag.
  reboot aboot;

	warmpt = (unsigned far*) MK_FP(0x0040, 0x0072); // Obtain far pointer to 0040:0072.
	aboot = (reboot) MK_FP(0xFFFF, 0x0000); // Obtain far pointer to FFFF:0000.

	if(strcmp("/w",argv[1]) == 0) {   // Decide whether or not to...
																	  // warmboot the CPU.
		*warmpt = (0x1234);
		warmfl = 1;
	}

  if(warmfl == 1)                   // Is warm boot flag set?
    printf("WARM booting.");        // YES, warm boot message.
  else
    printf("COLD booting.");        // NO, cold boot message.

	aboot();                          // Reboot the machine now...
                                    // by jumping to the function
                                    // pointer that was created.

    return 0;                       // SUCCESS!
} // end of main()
