/* STDBIN.C: example of binary redirection

		 It is sometimes necessary to change stdin or stdout to binary
		 prior to redirection. For instance, redirecting a graphics
		 screen to a graphics capable printer would require such a
		 change.  This program demonstrates a method for accomplishing
		 this task.
*/

#include <stdio.h>			// for fileno(), stdout and fputc()
#include <io.h>					// for ioctl() and setmode(),
#include <fcntl.h>			// for O_BINARY

// There are 3 things that need to be done.

//*******************************************************************
int main(void)
{
	int     hndl = fileno( stdout );
	int     info = ioctl( hndl, 0 );
 
	setmode( hndl, O_BINARY );               // handle to binary mode
	ioctl( hndl, 1, (info & 0xff) | 0x20 );  // device to raw mode
	stdout->flags |= _F_BIN;                 // stream to binary mode
 
	fputc('\n', stdout);
					//                               // your code goes here
					//
	ioctl( hndl, 1, info & 0xff );           // restore original mode
  return 0;
} // end of main()
