/* STRSTR.CPP: This program takes the average of numbers entered at
							 the command line.  Since command line arguments are
							 delivered to any C program in char* form via the argv[]
							 array, ASCII-to-double conversion must be done before
							 the computation can be performed. This is efficiently
							 done using a class of istrstream type as show in this
							 program.
*/

#include <strstream.h>
#include <string.h>

//*******************************************************************
main( int argc, char *argv[] )
{
	unsigned u;
	double total = 0, average = 0, d = 0;

	if ( argc == 1 ) {     // Not enough command line parameters!
		cout << endl << "Usage <filename> float float ...." << endl;
		return 1;
  }

  for ( u = 1; u < argc; ++u ) {
    istrstream istr( argv[u], strlen(argv[u]) );
		istr >> d;
    total += d;
  }

  average = total / (argc - 1);
  cout.setf( ios::fixed, ios::floatfield );
  cout << endl << "AVERAGE = " << average << endl;
  return 0;
}// end of main()
