/*----------------------------------------------------------*/
/*                                                          */
/*   Turbo C++ Tips & Techniques                            */
/*                                                          */
/*   Copyright (c) 1991 by Borland International            */
/*                                                          */
/*   Turbo Vision Sample program source file                */
/*                                                          */
/*----------------------------------------------------------*/
/*                                                          */
/*   This program illustrates what can be accomplished      */
/*   with approximately 160-170 lines of code using         */
/*   Turbo Vision for C++.                                  */
/*                                                          */
/*----------------------------------------------------------*/

// These #defines let the TV.H header file know which Turbo
// Vision classes we intend to use

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TCommandSet
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEditor
#define Uses_TEditWindow
#define Uses_TEvent
#define Uses_TFileDialog
#define Uses_TFileEditor
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TProgram
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu

#include <tv.h>            // Turbo Vision header file
#include "gadgets.h"       // Header file for the clock view
#include <stdarg.h>        
#include <dir.h>           

// Command constants used by TVSAMPLE

const unsigned cmAboutBox        = 100;
const unsigned cmNewFile         = 101;

const unsigned hcEditorOpen      = 0x1000;


// This is the main application class.  By deriving from TApplication,
// our application inherits most of the built in functionality of
// Turbo Vision.

class TSampleApp : public TApplication
{
protected:
  TEditWindow  *theEditor;
  TEditWindow  *theClipboard;
  Boolean      editorOpen;
  TClockView   *clock;

public:
  TSampleApp();
  static TMenuBar    *initMenuBar(TRect r);
  static TStatusLine *initStatusLine(TRect r);
  void               handleEvent(TEvent&);
  void               idle(void);
  void               updateCommands(void);
  void               newFile(char *aName);
  Boolean            closeEditor(Boolean destroyIt);
  void               openFile(void);
  static void        outOfMemory(void);
};

// Function prototype for the standard editor dialog function

ushort edDialog(int what, ...);


// This is the constructor for TSampleApp.  Here, initialization of
// application-specific variables is performed.

TSampleApp::TSampleApp(void) :
  TProgInit(&TSampleApp::initStatusLine,
            &TSampleApp::initMenuBar,
            &TSampleApp::initDeskTop)
{
  editorOpen = False;

  TRect r = getExtent();                      // Create the clock view
  r.a.x = r.b.x - 9;      r.b.y = r.a.y + 1;
  clock = new TClockView( r );
  insert(clock);                              // Insert clock into the desktop

  // Next, the clipboard is created.  The clipboard is necessary to support
  // Cut, Paste, Copy, etc. in this application
  
  r = deskTop->getExtent();
  theClipboard = new TEditWindow( r, 0, wnNoNumber );
  if (validView( theClipboard ))
  {
    TEditor::clipboard = (TEditor *) theClipboard->editor;
    TEditor::clipboard->canUndo = False;
    theClipboard->hide();
    deskTop->insert( theClipboard );
  }
}

// This function constructs the application's menu

TMenuBar *TSampleApp::initMenuBar(TRect r)
{
  TSubMenu& sub1 =
    *new TSubMenu("~\360~", kbAltSpace, hcNoContext) +
      *new TMenuItem("~A~bout...", cmAboutBox, kbNoKey, hcNoContext, 0);

  TSubMenu& sub2 =
    *new TSubMenu("~F~ile", kbAltF, hcNoContext) +
      *new TMenuItem("~N~ew", cmNewFile, kbNoKey, hcNoContext, 0) +
      newLine() +
      *new TMenuItem("~O~pen...", cmFileOpen, kbF3, hcNoContext, "F3") +
      *new TMenuItem("~S~ave", cmSave, kbF2, hcNoContext, "F2") +
      *new TMenuItem("Save ~a~s...", cmSaveAs, kbNoKey, hcNoContext, 0) +
      newLine() +
      *new TMenuItem("E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X");

  TSubMenu& sub3 =
    *new TSubMenu("~E~dit", kbAltE, hcNoContext)+
      *new TMenuItem("~U~ndo", cmUndo, kbNoKey, hcNoContext, 0) +
      newLine() +
      *new TMenuItem("Cu~t~", cmCut, kbShiftDel, hcNoContext, "Shift-Del") +
      *new TMenuItem("~C~opy", cmCopy, kbCtrlIns, hcNoContext, "Ctrl-Ins") +
      *new TMenuItem("~P~aste", cmPaste, kbShiftIns, hcNoContext, "Shift-Ins") +
      newLine() +
      *new TMenuItem("C~l~ear", cmClear, kbDel, hcNoContext, "Del");

  TSubMenu& sub4 =
    *new TSubMenu("~W~indow", kbAltW, hcNoContext)+
      *new TMenuItem("~R~esize", cmResize, kbCtrlF5, hcNoContext, "Ctrl-F5") +
      *new TMenuItem("~Z~oom", cmZoom, kbF5, hcNoContext, "F5") +
      newLine() +
      *new TMenuItem("~C~lose", cmClose, kbAltF3, hcNoContext, "Alt-F3");

  r.b.y = r.a.y + 1;
  return new TMenuBar( r, sub1 + sub2 + sub3 + sub4 );
}



// This function constructs the application's status line(s)
// Note that the TStatusDef class specifies a help-context
// range for which a particular status line should be displayed.
// Thus, this application will display two different status lines
// depending on which help-context is active.

TStatusLine *TSampleApp::initStatusLine(TRect r)
{
  r.a.y = r.b.y - 1;

  TStatusDef& statLine1 =
    *new TStatusDef(hcEditorOpen, hcEditorOpen) +
    *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit) +
    *new TStatusItem("~Alt-F3~ Close", kbAltF3, cmClose) +
    *new TStatusItem("~F2~ Save", kbF2, cmSave) +
    *new TStatusItem("~F3~ Open", kbF3, cmFileOpen) +
    *new TStatusItem(0, kbF10, cmMenu);

  TStatusDef& statLine2 =
    *new TStatusDef(0, 0xFFFF) +
    *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit) +
    *new TStatusItem(0, kbAltF3, cmClose) +
    *new TStatusItem(0, kbF10, cmMenu);

  return new TStatusLine( r, statLine1 + statLine2 );
}


// This function is called by Turbo Vision during idle periods.  It
// is used to update the clock view.

void TSampleApp::idle(void)
{
  TApplication::idle();
  clock->update();
}


// updateCommands is called to determine if the File|Save and the
// File|Save as menu options should be available.

void TSampleApp::updateCommands(void)
{
  TCommandSet cs;

  cs += cmSave;
  cs += cmSaveAs;
  if (editorOpen)
    deskTop->enableCommands(cs);
  else
    deskTop->disableCommands(cs);
}


// This function creates a new file editor (after closing any other open
// file editor) and inserts it into the desktop (makes it visible).

void TSampleApp::newFile(char *aName)
{
  if (!closeEditor(True))
    return;

  TRect r = deskTop->getExtent();

  r.a.x++;
  r.b.x -= 3;
  r.b.y -= 3;
  theEditor = new TEditWindow( r, aName, wnNoNumber );
  if (validView( theEditor ))
  {
    theEditor->helpCtx = hcEditorOpen;
    theEditor->editor->editorFlags &= ~(efBackupFiles);
    theEditor->editor->editorDialog = edDialog;
    deskTop->insert( theEditor );
    editorOpen = True;
  }
  updateCommands();
}


// This function is called to close any open file editor.  This function
// prompts the user to verify this action if there are un-saved changes
// present in the editor.

Boolean TSampleApp::closeEditor(Boolean destroyIt)
{
  Boolean retVal = True;

  if (editorOpen)
    if (theEditor->editor->modified)
      retVal = 
        (messageBox("\003You will lose your work if you proceed.",
                    mfConfirmation | mfOKCancel) == cmOK) ? True : False;
  if (retVal)
  {
    if (destroyIt)
      if (editorOpen)
        destroy( theEditor );
    editorOpen = False;
    updateCommands();
  }
  return retVal;
}


// openFile displays the standard file open dialog box.  If a file
// is selected from the dialog, it is loaded.

void TSampleApp::openFile(void)
{
  ushort control = cmCancel;
  char   buf[MAXPATH];

  TFileDialog *fd =
    new TFileDialog("*.*", "Load a file", "~N~ame", fdOpenButton, 1);
  if (validView( fd ))
    control = execView( fd );
  if (control == cmFileOpen || control == cmOK) 
  {
    if (closeEditor(True))
    {
      fd->getFileName(buf);
      newFile( buf );
    }
  }
  destroy( fd );
}


// This function is used to automatically handle:
//   1) the upload of program data to a dialog box
//   2) the modal execution of the dialog box
//   3) the download of data from the dialog box to the program
//   4) the destruction of the dialog box

ushort execDialog( TDialog *d, void *data )
{
  TView *p = TProgram::application->validView( d );
  if( p == 0 )
    return cmCancel;
  else
  {
    if( data != 0 )
      p->setData( data );
    ushort result = TProgram::deskTop->execView( p );
    if( result != cmCancel && data != 0 )
      p->getData( data );
    TObject::destroy( p );
    return result;
  }
}

typedef char *_charPtr;


// The edDialog function handles messages sent by the editor window.
// The editor window will call this function to handle certain special
// case situations (such as requests for file save and error conditions).

ushort edDialog(int what, ...)
{
  va_list arg;

  switch (what)
  {
    case edOutOfMemory:
      TSampleApp::outOfMemory();
      break;

    case edReadError:
    case edWriteError:
    case edCreateError:
      messageBox(mfOKButton | mfError, "\003Error during file I/O.");
      break;

    case edSaveAs:
      va_start( arg, what );
      return execDialog( new TFileDialog( "*.*",
                               "Save file as",
                               "~N~ame",
                               fdOKButton,
                               2 ), va_arg( arg, _charPtr) );
  }
  return cmCancel;
}


// Global out-of-memory handler

void TSampleApp::outOfMemory(void)
{
  messageBox("\003Not enough memory to complete operation.", mfOKButton | mfError);
}


// This is the sample application's handleEvent function.  This function
// is used to implement the commands unique to this program.  Turbo Vision
// calls this function whenever there is a message to be processed.

void TSampleApp::handleEvent(TEvent& event)
{
  if (event.what & evCommand)
  {
    if ((event.message.command == cmClose) && (editorOpen))
      if (!closeEditor(False))
        clearEvent( event );
  }

  TApplication::handleEvent( event );     // Call the original handleEvent

  if (event.what == evCommand)
  {
    switch (event.message.command)        // This might be a user command
    {                                     // (menu/status line selection)
      case cmNewFile:
        newFile(0);
        break;

      case cmFileOpen:
        openFile();
        break;

      case cmAboutBox:
        messageBox( mfInformation | mfOKButton, 
                    "\003Simple Turbo Vision Program\n\003\n" \
                    "\003(C) 1991 Borland International");
        break;

      default:
        return;
    }
    clearEvent( event );
  }
}


// This is the entire main program block.  The application is constructed.
// An editor is inserted into the desktop.  Finally, the application is run.

main(int argc, char *argv[])
{
  TSampleApp myIDE;
  char   fName[MAXPATH];
  char   *theFile = NULL;

  if (argc > 1)
  {
    strcpy( fName, argv[1] );
    fexpand( fName );
    if (validFileName( fName ))
      theFile = fName;
  }
  myIDE.newFile(theFile);
  myIDE.run();
}
