/* UMB1.CPP:  This program overloads the C++ new and delete operators
              to take advantage of Upper Memory Blocks if available
*/

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <dos.h>

#if !defined(__COMPACT__) && !defined(__LARGE__) && !defined(__HUGE__)
#error Usage of UMB Pointers via operator new requires far Data Memory Model
#endif

#define  NOTIMP 0x80                            // Not Implemented
#define  TOOBIG 0xB0                            // A smaller block is available
#define  NOUMB  0xB1                            // No UMBs are available
#define  BADUMB 0xB2                            // Invalid UMB specified

typedef void ( * FARFPTR )();                   // Function Pointer
extern  FARFPTR _new_handler;                   // Pointer to New Handler

enum  { FALSE = 0x00, TRUE = 0x01 };
static  int     UseXMSFlag = 0x00  ;            // Flags presence of XMM
static  FARFPTR XMSEntryPoint = NULL ;          // Entry Point to XMS Driver

int InitXMS()
{
    _AX = 0x4300;                               // Multplx ID+Presence Request
    geninterrupt( 0x2F );                       // Make Multiplex Call
    if ( _AL == 0x80 )                          // _AL == 0x80 -> XMM Present
    {
        unsigned Seg,  Off;
        _AX  = 0x4310;                          // Multplx ID+Address Request
        geninterrupt( 0x2F );                   // Make Multiplex Call
        Seg  = _ES;                             // Save Returned Segment
        Off  = _BX;                             // Save Returned Offset
        XMSEntryPoint= FARFPTR(MK_FP(Seg, Off));// Save XMM Entry Point
        UseXMSFlag++;                           // Flag Usage of XMS
        return ( TRUE );                        // XMM Present !
    }
    return ( FALSE );
}


int UMBStats( int & status )
{
    _DX = 0xFFFF;                               // Request FFFFh Paragraphs
    _AH = 0x10;                                 // Request UMB Function
    XMSEntryPoint();                            // Call Upon XMM
    status = _DX;                               // Save DX: Possible size info
    return ( int( _BL ));                       // Return Stats
}

void * AllocUMB( size_t size )
{
    size <<= 4;                                 // Convert to Paragraph
    size++;                                     // Adjust for possible carry
    _DX = size;                                 // DX ==  Requested Size
    _AH = 0x10;                                 // Request UMB Function
    XMSEntryPoint();                            // Call Upon XMM
    if ( _AX == 0x0001 )                        // Was request granted ?
    {
        _DX =  _BX;                             // Move Segment to DX
        _AX = 0x0000;                           // Clear Offset
        return(void *)(MK_FP(_DX, _AX));        // Make/Return Far Pointer
    }
    else
        return(void *)NULL;                     // Return NULLL
}

int FreeUMB( void  * UMBPtr )
{
    _DX = FP_SEG( UMBPtr );
    _AH = 0x11;
    XMSEntryPoint();
    if ( _AX == 0x0001 )
        return( 0x00 );
    else
        return( int( _BL ));
}

void * operator new ( size_t size )
{
    void  * ptr;
    if (UseXMSFlag != 00)
    {
        ptr  = AllocUMB( size );
        if ( ptr != NULL )
            return  ptr ;
    }
    while( ((ptr = malloc(size)) == NULL ) && _new_handler != NULL)
        _new_handler();
    return ptr;
}
 

void  operator delete ( void * ptr )
{
    if ((UseXMSFlag != 0x00) && (FP_SEG(ptr) > 0xA000))
        FreeUMB( ptr );
    else
        free( ptr );
}

int main(void)
{
    return 0;
}

