#if !defined( CALC_H )
#define CALC_H

//---------------------------------------------------------------------
//
//  CALC.H
//
//  defines the classes used in a simple four-function calculator
//
//---------------------------------------------------------------------

const char Constant = 'c';
const char None = 'n';
const char EOS = '\0';

class Scanner
{

public:

    Scanner( const char * );

    void nextToken();
    int curToken() { return curTok; }
    long value() { return lastValue; }
    int curCol() { return input - start; }

private:

    const char *input;
    const char *start;
    long lastValue;
    int curTok;

};

class MemStack
{

public:

    MemStack( size_t sz );
    ~MemStack();

    void *allocate( size_t );
    void free( void * );

private:

    char *memBlock;

    size_t size;
    size_t top;

};

class Production
{

public:

    virtual long eval() = 0;
    void *operator new( size_t sz ) { return mem.allocate( sz ); }
    void operator delete( void *ptr ) { mem.free( ptr ); }

protected:

    static void error( const char * );
    static void error( char );
    void expect( char );
    static Scanner *input;
    static int errorOccurred;

private:

    static MemStack mem;

};

class LongValue : public Production
{

public:

    LongValue();

    long eval();

private:

    long value;

};

class Factor : public Production
{

public:

    Factor();

    long eval();

private:

    Production *expr;

};

class AddOp : public Production
{

public:

    AddOp();

    long eval();
    static int isAddOp( char ch ) { return ch == '+' || ch == '-'; }

private:

    int op;
    Production *left;
    Production *right;

};

class MulOp : public Production
{

public:

    MulOp();

    long eval();
    static int isMulOp( char ch ) { return ch == '*' || ch == '/'; }

private:

    int op;
    Production *left;
    Production *right;

};

class Expression : public Production
{

public:

    Expression( const char * );
    ~Expression();

    long eval();
    int error() { return errorOccurred; }

private:

    Production *expr;

};

#endif  // CALC_H

