#define STRICT
#define WIN31

#include <owl.h>
#include <windowsx.h>
#include "childdlg.h"


_CLASSDEF( TApp )
_CLASSDEF( TMainWindow )
_CLASSDEF( TChildDlg   )


#define    WM_FOCUSDLG  ( WM_USER+100 )


// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TApp : public TApplication
{
    public:
	    TApp( LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
              LPSTR lpCmdLine, int nCmdShow ) :
        TApplication( AName, hInstance, hPrevInstance,
                      lpCmdLine, nCmdShow )
        {};
        virtual void InitMainWindow();
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TMainWindow : public TWindow
{
        static char szClassName[];
        PTChildDlg  DlgPtr;

    public:
        TMainWindow( PTWindowsObject, LPSTR, PTModule = NULL );
        virtual void SetupWindow();

        PTChildDlg  GetDlgPtr()
        {   return( DlgPtr );   }

        void  SetDlgPtr( PTChildDlg p )
        {   DlgPtr = p;   }

        LPSTR  GetClassName()
        {   return( szClassName );   }

        virtual void Exit( RTMessage ) = [ CM_FIRST+IDM_EXIT ]
        {   PostMessage( HWindow, WM_SYSCOMMAND, SC_CLOSE, 0L );   }

        virtual void FocusDlg  ( RTMessage ) = [ WM_FIRST+ WM_FOCUSDLG];
        virtual void ShowDialog( RTMessage ) = [ CM_FIRST+IDM_SHOWDLG ];
        virtual void WMActivate( RTMessage ) = [ WM_FIRST + WM_ACTIVATE ];
        virtual void WMSetFocus( RTMessage ) = [ WM_FIRST + WM_SETFOCUS ];
};
char TMainWindow::szClassName[] = "!App!ClassName";



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TChildDlg  : public TDialog
{
    public:
        TChildDlg( PTWindowsObject AParent, LPSTR AResource,
                   PTModule AModule = NULL ) :
        TDialog( AParent, AResource, AModule )
        {
        }
        virtual void WMSetFocus( RTMessage msg ) = 
                               [ WM_FIRST+WM_SETFOCUS ]
        {
            GetApplication()->SetKBHandler( this );
	        DefWndProc( msg );
        }
        virtual void WMMouseActivate( RTMessage msg ) =
                               [ WM_FIRST + WM_MOUSEACTIVATE ]
        {
            if ( (( PTMainWindow )Parent )->GetDlgPtr() != this )
            {
                (( PTMainWindow )Parent )->SetDlgPtr( this );
                PostMessage( Parent->HWindow, WM_FOCUSDLG, 0, 0 );
                SetWindowPos( HWindow, HWND_TOP, 0, 0, 0, 0, 
                              SWP_NOMOVE|SWP_NOSIZE );
            }
            DefWndProc( msg );
        }
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::ShowDialog( RTMessage )
{
    DlgPtr = new TChildDlg( this, "CHILD_DIALOG" );
    GetApplication()->MakeWindow( DlgPtr );
    if ( IsWindow( DlgPtr->HWindow ))
        SetFocus( DlgPtr->HWindow );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::FocusDlg( RTMessage )
{
    if ( DlgPtr  &&  IsWindow( DlgPtr->HWindow ) )
        SetFocus( DlgPtr->HWindow );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TApp::InitMainWindow()
{
    MainWindow = new TMainWindow( NULL, "Sample App" );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
TMainWindow::TMainWindow( PTWindowsObject AParent, LPSTR ATitle,
                          PTModule AModule ):
TWindow( AParent, ATitle, AModule )
{
    DlgPtr = NULL;
    AssignMenu( "MAINMENU" );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::SetupWindow()
{
    TWindow::SetupWindow();
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::WMActivate( RTMessage msg )
{
    TWindow::WMActivate( msg );
    if ( DlgPtr  &&  
         msg.WParam == TRUE  &&  
         IsWindow( DlgPtr->HWindow ) )
    {
        SetFocus( DlgPtr->HWindow );
    }
    msg.Result = 0;
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TMainWindow::WMSetFocus( RTMessage msg )
{
    PostMessage( HWindow, WM_FOCUSDLG, 0, 0 );
    DefWndProc( msg );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow)
{
    TApp App ( "Sample App", hInstance, hPrevInstance,
               lpCmdLine, nCmdShow);
    App.Run();
    return( App.Status );
}
















