/* Demo program for C Magic, copyright 1992, Jeff Napier & Another Company */

/* Include MAGIC.LIB and GRAPHICS.LIB in project file.  Compile in large   */
/* memory model only.  See TUTOR.DOC and MAGIC.TXT for more information    */

#include <magic.h>
#include <graphics.h>
#include <dos.h>     /* for delay() */
#include <string.h>  /* for programmer's toolkit */
#include <stdlib.h>  /* '' */
#include <stdio.h>   /* '' */
#include <conio.h>   /*  comment this out if using older version of TC */
#include <ctype.h>   /* '' */

void extkey(void);   /* prototypes for Programmer's Toolkit functions */
void asciichart(void);

void main() {
    magic_setup();   /* must include this with every program */

/*  musicon = 0; */  /* Uncomment this line if you want to turn */
                     /* off all the sound effects */

    bestvideo();     /* establishes best graphics mode for your computer */
    triplex();       /* builds TRIP.CHR into your .EXE file */
    settextjustify(CENTER_TEXT,TOP_TEXT);
    outtextxy(320,70,"Welcome to C MAGIC");
    bitmap();        /* switches to default, BITMAP font */
    outtextxy(320,120,
        "Copyright 1992, Another Company");
    setcolor(LIGHTMAGENTA);
    setlinestyle(0,0,3);
    ellipse(320,100,0,360,280,60);
    twinkle();       /* a C Magic sound effect */
    waitforuser();   /* like getch() but allows use of mouse buttons, too */
    pile("Now let's look at the code so far:");
    pile(" ");       /* pile() is a super-easy string handler from C Magic */
    pile("#include <magic.h>");
    pile("#include <graphics.h>");
    pile("void main() {");
    pile("   magic_setup();");
    pile("   bestvideo();");
    pile("   triplex();");
    pile("   settextjustify(CENTER_TEXT,TOP_TEXT);");
    pile("   outtextxy(320,70,\"Welcome to C MAGIC\");");
    pile("   bitmap();");
    pile("   outtextxy(320,120,");
    pile("      \"Copyright 1992, Another Company\");");
    pile("   setcolor(LIGHTMAGENTA);");
    pile("   setlinestyle(0,0,3);");
    pile("   ellipse(320,100,0,360,280,60);");
    pile("   twinkle();");
    pile("   waitforuser();");
    pile("              (Press any key to continue...)");
    getanykey(-1,-1);    /* displays strings, waits for user action  */
    pile("It's just that simple!");
    pop(-1,-1);          /* displays strings in a pop up box */
    delay(1500);         /* from DOS.H */
    restore();           /* replaces screen under pop() */
    pile("This demonstrates a cursor, available whether or not");
    pile("you have a mouse.  You can move the cursor with the");
    pile("arrow keys, [Home], [End], [Page Up], [Page Down]");
    pile("or the number keys.  Try it.  Press [Enter] or click");
    pile("the left mouse button when done.");
    pop(0,getmaxy() - 100);
    bugle();                 /* a C Magic sound effect */

    waste();                 /* clears keyboard buffer and mouse input */
    pointeron();             /* turn on graphics mode arrow cursor     */
    while (!left) poll();    /* read mouse button status and location  */
       /* poll() updates global ints px & py for location, and global  */
       /* chars left, center, and right for button status.             */
       /* Whether or not mouse is present, poll() also takes key input */
    pointeroff();            /* turns off graphics arrow               */
    restore();               /* removes all traces of pop-up box       */
    pile("Here's all the mouse code we just used:");
    pile(" ");
    pile("   waste();");
    pile("   pointeron();");
    pile("   while (!left) poll();");
    pile("   pointeroff();");
    pile(" ");
    pile("          (Press any key to contnue...)");
    getanykey(-1,-1);         /* pops up and waits for keypress        */


                      /* Programmer's Toolkit starts here */

    textvideo();             /* switches back to text video */
    mainback = GREEN;
    xclear();                /* clears background to green */
    centerjustify = 1;       /* center strings in pop-up boxes */
    mc = 1;                  /* mc = "Menu Choice" - the highlighted item */
    do {
       boxback = RED;        /* pop-up box background is set to red */
       pile("Programmer's Toolkit");
       pile("Copyright 1992, Freeware by Another Company");
       pop(18,2);            /* pop up a box at coordinates 18,2 */
       boxback = BLUE;
       boxtext = WHITE;
       border = WHITE;
       strcpy(sent[1],"ASCII Chart");
       strcpy(sent[2],"Extended Keys");
       strcpy(sent[3],"Quit");
       menu(-1,-1);          /* pop up a menu, centered on screen */
       if (u == 13) switch (mc) {
          case 1 : asciichart(); break;
          case 2 : extkey();
       }            /* branch to a function, depending on user's    */
		    /* selection from menu.  These functions are    */
		    /* about 15 lines below this line in this file. */
       restore();   /* get rid of title pop-up */
   }
   while (!((u == 13) && (mc == 3)));
   xclear();
   centerjustify = 0;
   pile("The complete code for this program is in the file DEMO.C.");
   pile("You can cut out the preliminary stuff to compile the");
   pile("Programmer's Toolkit by itself, or you can cut, paste");
   pile("and experiment from this demo to design your own programs.");
   pile("There's far more to C MAGIC.  See TUTOR.DOC and MAGIC.TXT");
   pile("for more functions and more information.");
   pile(" ");
   pile("        Thanks for looking at the C Magic library.");
   getanykey(-1,-1);   /* pop up centered on screen, waits for user */
   cleanup();
}

    /* This function displays ASCII information */
    /* corresponding to any key pressed. */

void extkey(void){
   char tempstr[3];
   xclear();
   pile("Press any key to see it's extended code");
   pile("Press [Esc] when done.");
   pop(18,3);           /* pop up box at coordinates 18,3 */
   strcpy(sent[1]," ");  /* makes an empty box */
   strcpy(sent[2],"");
   do {                   /* this loop executes until uses presses [Esc] */
      getanykey(-1,-1);   /* display our result in a pop-up box */
      if (keydetect == 2) strcpy(sent[1],"#0 + ");  /* an extended key */
      sprintf(tempstr,"%c",u);                      /* build a string */
      if ((u == 13) || (u == 8) || (u == 10) || (u == 7))
         strcat(sent[1]," ");
         else strcat(sent[1],tempstr);       /* if character is printable */
                                             /* then we add it to string  */
      itoa(u,tempstr,10);                    /* and convert it's ASCII #  */
      strcat(sent[1],"(#");                  /* to a string and add that, */
      strcat(sent[1],tempstr);               /* too.                      */
      strcat(sent[1],")");
   }
   while (u != 27);                       /* ASCII 27 is the [Escape] key */
   xclear();
   } /* end of function extkey() */

void asciichart(void){
   char x = 1,y = 1;
   int temp;
   char tempstr[3];
   textcolor(YELLOW); textbackground(BLUE);
   clrscr();
   for (temp = 0; temp < 256; temp++) {     /* a loop that repeats 256 times */
      gotoxy(x,y);                          /* and prints ASCII# / character */
      cprintf(" ");
      if (temp < 10) cprintf(" ");
      if (temp < 100) cprintf (" ");
      if ((temp != 7) && (temp != 8) && (temp != 10)
      &&(temp != 13) && (temp != 27))
      cprintf("%d=%c ",temp,temp);
      else cprintf("%d=",temp);
      y++;
      if (y > 25){                         /* in readable columns on screen */
         y = 1;
         x += 7;
      } /* end of if y > 25 */
   } /* end of for loop */
   waitforuser();                          /* wait for user to press a key */
   xclear();
} /* end of function asciichart() */

