//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
//  Turbo Vision - Modifying the desktop pattern
//
//  - This sample code demonstrates one method of modifying the desk top
//  to change the desk-top pattern.
//
//  - The TApplication::initDeskTop function is used to initialize the
//  desk top.  This is defined by the object returned by initDeskTop.
//  In order to change the pattern of the desk top, you must do the
//  following:
//      1.  Derive a class from TDeskTop which modifies the default
//      desk top.  The initBackground function of your derived class
//      returns a TBackground object which is initialized with a
//      character which determines the background pattern.
//      2.  Redefine the initDeskTop function in the class that you
//      derive from TApplication to return an object of your new
//      desk-top class.
//  Additionally, in order to modify the desk-top colors, you need to
//  do the following:
//      3.  Derive a new TBackground object in which you redefine the
//      getPalette function to return your desired palette.
//      4.  Modify the initDeskTop function mentioned in step 2 to
//      return the new TBackground object you have defined.
//------------------------------------------------------------------------

#define Uses_TApplication
#define Uses_TBackground
#define Uses_TButton
#define Uses_TKeys
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#include <tv.h>

//========================================================================
//  global data
//------------------------------------------------------------------------
const cmAbout   = 100;  // User selected menu item 'About'

// cpAppDeskTop used in newly defined desktop for background
#define cpNewDeskTop "\x13"

// character to be used for background pattern
#define PATTERN 225

//========================================================================
//  class definitions
//------------------------------------------------------------------------
class TApp : public TApplication {
    //  main application class

public:
    TApp();

    // virtual functions to be locally redefined
    static TMenuBar *initMenuBar( TRect r );
    static TDeskTop *initDeskTop( TRect r );
    void handleEvent( TEvent &event );

    // declare new functions
    void AboutDialog();

};

//------------------------------------------------------------------------
class TNewDeskTop : public TDeskTop
{   // we derive a new desk top which will instantiate the background
    // object with the character we select for the pattern
    // also, the initBackground function is overridden to return
    // our specialized TNewBackground
public:
    TNewDeskTop( TRect& r );
    static TBackground* initBackground( TRect r );
};

//------------------------------------------------------------------------
class TNewBackground : public TBackground
{   // we derive a new background for to return our
    // specified palette
public:
    TNewBackground( TRect& r, char pattern );
    TPalette& getPalette() const;
};

//========================================================================
//  implementation of TApp
//------------------------------------------------------------------------
TApp::TApp() : TProgInit( &TApplication::initStatusLine,
                    &TApp::initMenuBar, &TApp::initDeskTop )
{
    // use default status line
}

//------------------------------------------------------------------------
// define menu bar
//------------------------------------------------------------------------
TMenuBar *TApp::initMenuBar( TRect r )
{
    r.b.y = r.a.y + 1;
    return( new TMenuBar( r, new TMenu(
        *new TMenuItem( "~A~bout", cmAbout, kbAltA, hcNoContext, 0 )
        ) ) );
}

//------------------------------------------------------------------------
//  redefine desktop initialization to cause usage of newly
//  defined desktop
//------------------------------------------------------------------------
TDeskTop *TApp::initDeskTop( TRect r )
{
    // initDeskTop is passed a TRect which is the size of the
    // application's window - in our case the whole screen
    r.a.y++;
    r.b.y--;
    return new TNewDeskTop( r );
}

//------------------------------------------------------------------------
// event-handler
//------------------------------------------------------------------------
void TApp::handleEvent (TEvent &event)
{
    // override the handleEvent so we can call the about box
    TApplication::handleEvent( event );
    if( event.what == evCommand )
    {
        switch( event.message.command )
        {
            case cmAbout:
                AboutDialog();
                clearEvent( event );
                break;
        }
    }
}

//------------------------------------------------------------------------
// create modal About dialog box
//------------------------------------------------------------------------
void TApp::AboutDialog()
{
    // remind the user what is being demonstrated
    TDialog *pd = new TDialog( TRect( 0, 0, 35, 12 ), "About" );
    if (pd)
    {
        pd->options |= ofCentered;
        pd->insert( new TStaticText( TRect( 1, 2, 34, 7 ),
                "\003Turbo Vision Example\n\003\n"
                "\003Modifying the desk top\n\003\n"
                "\003Borland Technical Support"));
        pd->insert( new TButton( TRect( 3,9,32,11 ), "~O~k",
                                cmOK, bfDefault ) );
        deskTop->execView( pd );
    }
    destroy( pd );
}

//========================================================================
//  implementation of TNewDeskTop
//------------------------------------------------------------------------
TNewDeskTop::TNewDeskTop( TRect& r ) :
                    TDeskTop( r ), TDeskInit( &initBackground )
{
}

//------------------------------------------------------------------------
TBackground *TNewDeskTop::initBackground( TRect r )
{
    // initializing the TBackground object allows us
    // to pass it a character for the desktop pattern
    return new TNewBackground( r, PATTERN );
}

//========================================================================
//  implementation of TNewBackground
//------------------------------------------------------------------------
TNewBackground::TNewBackground( TRect& r, char pattern ) :
                        TBackground( r, pattern )
{
}

//------------------------------------------------------------------------
TPalette& TNewBackground::getPalette() const
{
    // return our palette
    static TPalette palette( cpNewDeskTop, sizeof( cpNewDeskTop ) - 1 );
    return palette;
}

//========================================================================
int main(void)
{
    // now for the tough stuff
    TApp myApp;
    myApp.run();
    return 0;
}
