/*
// CPORT.H
//
// Header file for Cport Communications Library
//
// Copyright (c) 1993 Bri Productions
//
*/

#ifndef _CPORT_H_
#define _CPORT_H_

#include "stddef.h"

#if defined  __TURBOC__
# if  __STDC__
#  define  _Cdecl
# else
#  define  _Cdecl  cdecl
# endif
#elif defined  __ZTC__
# define  _Cdecl
#elif defined  M_I86 && !defined  __ZTC__
# if !defined NO_EXT_KEYS
#  define  _Cdecl  cdecl
# else
#  define  _Cdecl
# endif
#else
#define  _Cdecl
#endif



/*
//-------------------------------------
//
// com port id's
//
//-------------------------------------
*/

#define  PORT0 0x03F8                  /* hard port addresses  */
#define  PORT1 0x02F8
#define  PORT2 0x03E8
#define  PORT3 0x02E8

#define  BIOS0 (*(int far *)0x400000l) /* bios port addresses  */
#define  BIOS1 (*(int far *)0x400002l)
#define  BIOS2 (*(int far *)0x400004l)
#define  BIOS3 (*(int far *)0x400006l)

#define  IRQ2  0x2000                  /* irq's                */
#define  IRQ3  0x3000
#define  IRQ4  0x4000
#define  IRQ5  0x5000
#define  IRQ6  0x6000
#define  IRQ7  0x7000

#define  COM1  (PORT0 | IRQ4)          /* hard 'com' ports     */
#define  COM2  (PORT1 | IRQ3)
#define  COM3  (PORT2 | IRQ4)
#define  COM4  (PORT3 | IRQ3)
                                       /* bios 'com' ports     */

#define  BCOM1 ((BIOS0 | 0x1000) + ((BIOS0 << 4) & 0xf000))
#define  BCOM2 ((BIOS1 | 0x1000) + ((BIOS1 << 4) & 0xf000))
#define  BCOM3 ((BIOS2 | 0x1000) + ((BIOS2 << 4) & 0xf000))
#define  BCOM4 ((BIOS3 | 0x1000) + ((BIOS3 << 4) & 0xf000))


/*
//-------------------------------------
//
// baud rate divisors
//
//-------------------------------------
*/

#define  B115200  1
#define  B57600   2
#define  B38400   3
#define  B19200   6
#define  B9600    12
#define  B7200    16
#define  B4800    24
#define  B3600    32
#define  B2400    48
#define  B2000    58
#define  B1800    64
#define  B1200    96
#define  B600     192
#define  B300     384
#define  B150     768
#define  B110     1047
#define  B75      1536
#define  B50      2304


/*
//-------------------------------------
//
// word lengths
//
//-------------------------------------
*/

#define  W8    3
#define  W7    2
#define  W6    1
#define  W5    0
#define  WMASK 3


/*
//-------------------------------------
//
// stop bits
//
//-------------------------------------
*/

#define  S1    0
#define  S2    4
#define  SMASK 4


/*
//-------------------------------------
//
// parity
//
//-------------------------------------
*/

#define  NONE     0x00
#define  ODD      0x08
#define  EVEN     0x18
#define  MARK     0x28
#define  SPACE    0x38
#define  PMASK    0x38


/*
//-------------------------------------
//
// handshaking
//
//-------------------------------------
*/

#define  DTR      0x001
#define  RTS      0x002
#define  S_RX     0x004
#define  S_TX     0x008
#define  CTS      0x010
#define  DSR      0x020
#define  DCD      0x080

#define  SOFT     ((S_RX) | (S_TX))
#define  HARD     ((RTS)| (CTS))
#define  HARD1    ((DTR)| (DSR))
#define  HARD2    ((RTS)| (CTS))


/*
//-------------------------------------
//
// error codes
//
//-------------------------------------
*/

#define  OVERUN    0x002         /* overrun error           */
#define  PARITY    0x004         /* parity error            */
#define  FRAMING   0x008         /* framing error           */
#define  BREAK     0x010         /* break detect            */
#define  RX_FIFO   0x080         /* error in recieve fifo   */
#define  TXFULL    0x100         /* transmit queue overflow */
#define  RXFULL    0x200         /* receive queue overflow  */


/*
//-------------------------------------
//
// status codes
//
//-------------------------------------
*/

#define  DCTS        0x001       /* delta clear to send           */
#define  DDSR        0x002       /* delta data set ready          */
#define  TERI        0x004       /* trailing edge ring  indicator */
#define  DDCD        0x008       /* delta data carrier detect     */
#define  CTS         0x010       /* clear to send                 */
#define  DSR         0x020       /* data set ready                */
#define  RI          0x040       /* ring indicator                */
#define  DCD         0x080       /* data carrier detect           */

#define  S_TX_OFF    0x0100      /* software transmit off         */
#define  U_TX_OFF    0x0200      /* user transmit off             */
#define  S_RX_OFF    0x0400      /* software receive off          */
#define  X_REQST     0x0800      /* send XON/XOFF request         */
#define  X_SENT      0x1000      /* X character send (TX_DIRECT)  */
#define  U_TX_DIR    0x2000      /* In direct transmit mode       */

/*
//-------------------------------------
// 
// Uart types ComUart
//
//-------------------------------------
*/
                                                                        
#define  INS8250   1             /* INS8250/INS8250-B                   */
#define  NS16450   2             /* INS8250A/NS16450/NS16C450/NS16C450A */
#define  NS16550   3             /* NS16550                             */
#define  I82510    4             /* 82510 (Intel)                       */


/*
//-------------------------------------
//
// ComTurbo options
//
//-------------------------------------
*/

#define  TIMER       0x01     /* timer bit (irq0)              */
#define  KEYBOARD    0x02     /* keyboard bit (irq1)           */
#define  CASCADE     0x04     /* cascade/reserved bit (irq2)   */


/*
//-------------------------------------
//
// NS16550 rx FIFO trigger levels
//
//-------------------------------------
*/

#define  T550_1      0x00
#define  T550_4      0x40
#define  T550_8      0x80
#define  T550_14     0xC0


/*
//-------------------------------------
//
//
//
//-------------------------------------
*/

/*
//-------------------------------------
//
// typedefs and structures
//
//-------------------------------------
*/

#ifndef _BYTE_
#define _BYTE_
typedef unsigned char byte;
#endif

	/* Make sure this structure is byte packed
	*/

#ifdef M_I86
#pragma pack(1) 
#endif

   /** Do not change this structure **/

struct C_param{
   unsigned id;               /* com port id                      */
   int      baud;             /* baud rate                        */
   byte     mode;             /* word length, stop bits, parity   */
   unsigned rxQ;              /* receive queue size               */
   unsigned txQ;              /* transmit queue size              */
   byte     htype;            /* handshaking type                 */
   unsigned thresh;           /* handshaking threshold (rx queue) */
   };

typedef struct C_param CPARAM;
typedef void* COM;

#ifdef M_I86
#pragma pack() 
#endif

/*
//-------------------------------------
//
// Misc
//
//-------------------------------------
*/

enum { OFF  , ON   };
#define TX_DIRECT    0x20


/*
//-------------------------------------
//
// comopen_errno
//
//-------------------------------------
*/

#define  NO_ERR   0        /* no error                         */
#define  OPENED   1        /* port already opened              */
#define  BAD_ID   2        /* bad id parameter                 */
#define  NO_UART  3        /* no uart chip found               */
#define  RX_ALC   4        /* receive queue allocation error   */
#define  TX_ALC   5        /* transmit queue allocation error  */
#define  MAX_PORT 6        /* max number of com ports opened   */
#define  IRQ_CTN  7        /* interrupt contention             */
#define  GEN_ALC  8        /* general allocation error         */


/*
//-------------------------------------
//
// function macros
//
//-------------------------------------
*/

#define  ComOut1(c,a)         ComMcr(c,a, 0x04)
#define  ComRts(c,a)          ComMcr(c,a, 0x02)
#define  ComDtr(c,a)          ComMcr(c,a, 0x01)


/*
//-------------------------------------
//
// function prototypes
//
//-------------------------------------
*/

#ifdef __cplusplus
extern "C" {
#endif

   /* control functions */

COM      _Cdecl   ComOpen        (unsigned id, int baud, byte mode, unsigned rxQ, unsigned txQ);
COM      _Cdecl   ComOpenS       (const CPARAM* param);
COM      _Cdecl   ComClose       (COM com);
void     _Cdecl   ComHandshake   (COM com, byte htype, unsigned thresh);
void     _Cdecl   ComParam       (COM com, CPARAM* param);
void     _Cdecl   ComBaud        (COM com, int baud);
void     _Cdecl   ComMode        (COM com, byte mode);
int      _Cdecl   ComTx          (COM com, int cmnd);
void     _Cdecl   ComTurbo       (int options);
void     _Cdecl   ComCloseAll    (void);
void     _Cdecl   ComNS550       (COM com, int trigger);
unsigned _Cdecl   ComRxQ         (COM com, unsigned size);
unsigned _Cdecl   ComTxQ         (COM com, unsigned size);


   /* input functions    */

char     _Cdecl   ComGetc        (COM com);
unsigned _Cdecl   ComLenRx       (COM com);
char    *_Cdecl   ComGets        (COM com, char *str, int maxc, char termc);
unsigned _Cdecl   ComIn          (COM com, void *abyte, unsigned nbyte);
void     _Cdecl   ComFlushRx     (COM com);
char     _Cdecl   ComPeek        (COM com);
unsigned _Cdecl   ComRxScan      (COM com, char c);


   /* output functions  */

int      _Cdecl   ComPutc        (COM com, char c);
unsigned _Cdecl   ComLenTx       (COM com);
int      _Cdecl   ComPuts        (COM com, const char *str);
unsigned _Cdecl   ComOut         (COM com, const void *abyte, unsigned nbyte);
void     _Cdecl   ComFlushTx     (COM com);
void     _Cdecl   ComTxWait      (COM com);


   /* status functions  */

void     _Cdecl   ComMcr         (COM com, byte on_off, byte bits);
unsigned _Cdecl   ComError       (COM com);
unsigned _Cdecl   ComStatus      (COM com);
int      _Cdecl   ComUart        (COM com);


   /* misc fuctions  */

void     _Cdecl   ComSetBreak    (COM com);
void     _Cdecl   ComClrBreak    (COM com);
void     _Cdecl   ComPutScrtch   (COM com, byte abyte);
byte     _Cdecl   ComGetScrtch   (COM com);


   /* data integrity functions   */

byte          _Cdecl ComChecksum (const void *abyte, unsigned nbyte);
unsigned      _Cdecl ComCrc16    (const void *abyte, unsigned nbyte);
unsigned long _Cdecl ComCrc32    (const void *abyte, unsigned nbyte);


   /* debug */

COM      _Cdecl   ComHandle      (COM com);


#ifdef __cplusplus
}           /* extern "C" */
#endif



/*
//-------------------------------------
//
// comopen_errno 
//
//-------------------------------------
*/


#ifdef __cplusplus
extern "C" int   comopen_errno;
#else
extern   int   comopen_errno;
#endif



/*
//-------------------------------------
//
// Other header files
//
//-------------------------------------
*/

   /* Implicit and explicit C++ inclusion
   */
#ifdef __cplusplus
#include   "cport.hpp"
#endif


   /* Xmodem inclusion
   */
#ifdef Uses_Xmodem
#include "xmodem.h"
#endif

   /* Zmodem inclusion
   */
#ifdef Uses_Zmodem
#include "zmodem.h"     /* Not yet implemented  */
#endif


#endif      /* CPORT.H */

