#ifndef __CRC_H
#define __CRC_H

// Copyright ***********************************************************
//
// 	The information in this file is copyright 1991 by David Orme.
//
//		Anyone may use this information for any purpose as long as he takes
//		responsability for any and all libility incurred from its use
//		or misuse and acknowledges its use in the user documentation.  This
//		information is provided AS IS with no warrenty of any kind, either
//		expressed or implied.
//
// End *****************************************************************


// Contents *********************************************************
//
//	CRC class definition
//
// Description
//
//	Implements a CRC class using the CCITT CRC-16 polynomial using
//	inline assembly to perform the calculation.  Suitable for XModem
//	or CIS B+ protocol implementations.
//
// End **************************************************************


// Interface Dependencies -------------------------------------------

// --None--


// Implementation Dependencies --------------------------------------

// --None--



class CRC {
private:
	unsigned		crc_16;								// CRC accumulator
public:
	// Constructor...
	CRC(int initialize=0)	{ crc_16=initialize; }

	// Member funcs...
	void			initialize(unsigned value)			{ crc_16=value; }
					operator unsigned int() 			{ return crc_16; }
	unsigned		operator +=( unsigned int value );
};

// Description -------------------------------------------------------------
//
//		Defines the CRC class.  The CRC is initialized upon construction,
//		and a running value is kept in the local crc_16 accumulator.
//
// Constructor
//
//		CRC( int initialize )
//
//      Initialize to 0 for XMODEM and -1 for CIS B+ protocol.
//
// Public Members
//
//      operator unsigned int()
//
//		This operator defines an explicit or implict cast from a CRC object
//		to an unsigned integer.  It returns the current value of the CRC
//		accumulator.
//
//		unsigned int operator +=( unsigned int value )
//
//		Adds value to the current CRC accumulator and returns the result--
//		the new current CRC.
//
// End ---------------------------------------------------------------------



#endif

