/***************************************************************************
These C++ classes are copyright 1990, by William Herrera.

All those who put this code or its derivatives in a commercial product MUST
mention this copyright in their documentation for users of the products in
which this code or its derivative classes are used.  Otherwise, this code
may be freely distributed and freely used for any purpose.

Enhancements: 1991 by David Orme
	*  General cleanup.
			- I/O now takes advantage of C++ overloading.
			- Serial port I/O functionality now only in Serial class.
			- Modem functionality now only in Modem class.
	*  Possible to easily implement file Xfr prots now.
	*  CCITT CRC-16 class added							-- 2-20-1991
	*  BIOS Timer class added								-- 2-22-1991
	*  Optional timeout on all input routines added	-- 2-25-1991

***************************************************************************/

// file serialpo.hpp class declaration of SerialPort class.

#ifndef SERIALPO_HPP
#define SERIALPO_HPP 1

#include <string.h>
#include "comports.hpp"
#include "timer.h"

class SerialPort
{
protected:
// the protected data within each Serial object

	int port_number;
	boolean translatenewline;	// These are used in '\r\n' <--> '\n'
	boolean lastin_wascr;		// translation.
	uart * com;					// pointer to the uart for port
	Timer T;					// Async timer

public:
	SerialPort(int portnum = 1, int speed = 2400, 
					parity_t p = NOPAR, int sbits = 1, 
					int dbits = 8, boolean trans = false);
	virtual ~SerialPort();
	uart * GetUART();
	void SetSpeed(int s);
	int GetSpeed();
	void SetParity(parity_t p);
	parity_t GetParity();
	void SetStopBits(int s);
	int GetStopBits();
	void SetDataBits(int s);
	int GetDataBits();
	void PurgeInput();
	void FlushOutput();
	void PurgeOutput();
	boolean CarrierPresent();
	void RaiseDTR();
	void DropDTR();
	void SetTimer(float seconds = 0.0e1) { T.Set(seconds); }
	int TimeOut() 	  	         { return T.TimeOut(); }
	void Pause(int ms = 550);
	void Break(int ms = 550);
	void SetDoIfNoCarrier(void (*f)());
	void SetDoOnRing(void (*f)());
	boolean InputEmpty();
	boolean OutputEmpty();
	boolean OutputReady();

	// Binary write (no /r/n xlation)
	void Write(void * p,int n);

	void Write(char c)		{ Write(&c, sizeof(char)); }
	void Write(char *s)	 	{ Write(s, strlen(s)); }
	void Write(int i)		{ Write(&i, sizeof(int)); }
	void Write(unsigned i)	        { Write(&i, sizeof(unsigned)); }
	void Write(long l)		{ Write(&l, sizeof(long)); }
	void Write(float f)		{ Write(&f, sizeof(float)); }
	void Write(double d)		{ Write(&d, sizeof(double)); }

	// Binary read with timeout in s seconds
	int Read(char * p, int n, float secs = 0.0e1);

	int Read(char & c, float s = 0.0e1)  { return Read((char*)&c, sizeof(char), s); }
	int Read(int& i, float s = 0.0e1)    { return Read((char*)&i, sizeof(int), s); }
	int Read(unsigned& i,float s = 0.0e1){ return Read((char*)&i, sizeof(unsigned), s); }
	int Read(long& l, float s = 0.0e1)   { return Read((char*)&l, sizeof(long), s); }
	int Read(float& f, float s = 0.0e1)  { return Read((char*)&f, sizeof(float), s); }
	int Read(double& d, float s = 0.0e1) { return Read((char*)&d, sizeof(double), s); }

	// Translated I/O (if /r/n xlation enabled)
	int Receive(char& ch, float secs = 0.0e1); // -1 returned on timeout
	void Send(char ch);
	void Send(char * s);
};

#endif

// end of file serialpo.hpp
