/*
   CPPTask - A Multitasking Kernel For C++

   SIO.HPP - Serial I/O interface routine definitions.

   Version 1.0 08-12-91

   Ported by Rich Smith from:

   Public Domain Software written by
      Thomas Wagner
      Patschkauer Weg 31
      D-1000 Berlin 33
      West Germany
*/


#define COM1PORT   0x80     // COM1, relative
#define COM2PORT   0x81     // COM1, relative

#define XON       0x11
#define XOFF      0x13

// Parity values for "v24_change_parity"

#define PAR_NONE  0x00
#define PAR_EVEN  0x18
#define PAR_ODD   0x08
#define PAR_MARK  0x28
#define PAR_SPACE 0x38

// Modem control bits for "v24_watch_modem"

#define CTS       0x10
#define DSR       0x20
#define RI        0x40
#define CD        0x80

// Values for "v24_protocol"

#define XONXOFF   0x01
#define RTSCTS    0x02

// Internal structures

struct  port_data;       // forward reference
class   commport;         // forward reference
typedef port_data far *portptr;
typedef commport far *commptr;

struct port_data {
   portptr     next;    // Next defined port
   int         pnum;    // Internal Port ID
   commptr     sio;     // SIO control block
   int         base;    // Port base
   byte        irq;     // IRQ level
   byte        vector;  // Interrupt vector number
};


class commport {
   commptr  next;           // Next link for shared IRQs
   farptr   savvect;        // Interrupt vector save location
   portptr  port;           // Port descriptor pointer
   int      port_base;      // Port base I/O address
   int      r_xoff;         // Receive disable (XOFF sent)
   int      t_xoff;         // Transmit disable (XOFF received)
   int      xoff_threshold; // Pipe free threshold for XOFF
   int      xon_threshold;  // Pipe free threshold for XON
   byte     clcontrol;      // Current line control reg
   byte     cmodcontrol;    // Current modem control reg
   byte     irqbit;         // IRQ-Bit for this port
   byte     civect;         // Interrupt Vector for this port
   byte     modstat;        // Current modem status
   byte     wait_xmit;      // Transmit delayed
   byte     xmit_pending;   // Transmit in progress
   byte     rtsoff;         // RTS turned off by protocol
   byte     overrun;        // Pipe full on receive
   byte     modem_flags;    // Transmit enable modem flags
   byte     flags;          // Protocol flags

   byte     save_lcon;      // Previous line control value
   byte     save_mcon;      // Previous modem control value
   byte     save_inten;     // Previous interrupt control value
   byte     save_irq;       // Previous interrupt bit value
   byte     save_bd1;       // Previous baud rate lower byte
   byte     save_bd2;       // Previous baud rate upper byte

   byte     restore;        // Restore modem params at destruct?

   wpipe    rcv_pipe;       // Received characters
   pipe     xmit_pipe;      // Transmit pipe

// private member functions

   void chng_rts(int on);
   void transmit_ready(void);
   void modem_status_int(void);
   void receive_ready(void);
   void sioint(void);
// friend declarations
   friend void interrupt far sioint3(void);
   friend void interrupt far sioint4(void);
public:
   commport (int port, int init,
             farptr rcvbuf, word rcvsize,
             farptr xmitbuf, word xmitsize);
   ~commport ();
   void far change_rts (int on);
   void far change_dtr (int on);
   void far change_baud (long rate);
   void far change_parity (int par);
   void far change_wordlength (int len);
   void far change_stopbits (int n);
   void far watch_modem (byte flags);
   void far protocol (int prot, word offthresh, word onthresh);
   int far  send (byte ch, dword timeout);
   int far  receive (dword timeout);
   int far  rcv_overrun (void);
   int far  check (void);
   int far  modem_status (void);
   int far  complete (void);
   int far  wait_complete (dword timeout);
   void far flush_receive (void);
};

