
/*
   Test program for checking the CTask serial I/O interface.
*/

#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>

#include "task.hpp"
#include "tsklocal.hpp"
#include "sio.hpp"

#define COM1PORT 0x80     /* COM1, relative */
#define COM2PORT 0x81     /* COM2, relative */
#define BAUD     9600L    /* Baudrate */

#define STACKSIZE 2048

unsigned int _stklen = 3 * STACKSIZE;  /* Two tasks + main Task Stack */

void far task1 (void);
local char stack1 [STACKSIZE];
local task tcb1((funcptr)task1, (byteptr)stack1, STACKSIZE, PRI_STD, NULL);

void far task2 (void);
local char stack2 [STACKSIZE];
local task tcb2((funcptr)task2, (byteptr)stack2, STACKSIZE, PRI_STD, NULL);

flag halt;

word rcvbuf [10000];    // receive buffer for serial port
byte xmtbuf [100];      // transmit buffer for serial port

commport com1(COM1PORT, 1, rcvbuf, sizeof(rcvbuf),  // create com1 port
                           xmtbuf, sizeof(xmtbuf));

int endrun, err;

/*
   Task 1 reads characters from the serial line and displays them on
   the screen. While the halt flag is set, characters are not read,
   so the XON/XOFF and RTS/CTS protocol can be tested for the receiving 
   side.
*/

void far task1 (void)
{
   word ch;

   printf ("Task 1 started\n");
   while (!endrun)
      {
      halt.wait_flag_clear (0L);
      if (endrun)
         return;
      ch = com1.receive (0L);
      putch (ch);
      if (ch & 0xff00)
         {
         err = 1;
         printf ("\n%c*%02x*", ch, ch >> 8);
         }
      }
}


/*
   Task 2 reads characters from the keyboard and sends them to the
   serial port. If 'h' is entered, the halt flag is set, so task1
   stops reading. If 'c' is entered, the halt flag is cleared.
   Entering 'e' stops the program.
*/

void far task2 (void)
{
   int ch;

   printf ("Task 2 started\n");
   while (!endrun)
      {
      ch = t_read_key () & 0xff;
      switch (tolower (ch))
         {
         case 'h':   halt.set_flag ();
                     puts ("-halt-");
                     break;

         case 'c':   halt.clear_flag ();
                     err = 0;
                     puts ("-continue-");
                     break;

         case 'e':   puts ("-end-");
                     endrun = 1;
                     halt.clear_flag ();
                     main_tcb.wake_task ();
                     break;

         default:    com1.send (ch, 0L);
                     break;
         }
      }
}


main ()
{
   endrun = 0;

   com1.change_baud (BAUD);

   tcb1.start_task ();
   tcb2.start_task ();

   tasker.preempt_on ();
   t_delay (0L);

   endrun = 1;
   puts ("******** Main Task *********");

   main_tcb.set_priority (10);
   tasker.schedule ();
   tasker.preempt_off ();

   puts ("******** End Run *********");
   return 0;
}

