/*
   CPPTask - A Multitasking Kernel For C++

   TSKCONF.HPP - Configuration definitions

   Version 1.0 08-12-91

   Ported by Rich Smith from:

   Public Domain Software written by
      Thomas Wagner
      Patschkauer Weg 31
      D-1000 Berlin 33
      West Germany

   This file is new with Version 1.1
*/

/*
   CLOCK_MSEC     if 1, all timeouts are specified in milliseconds.
                  Requires floating point library.
                  Changing requires recompile of tskmain.c and tsksub.c.
*/

#define CLOCK_MSEC      0

/*
   PRI_TIMER      Priority of the timer task. Normally higher than any
                  other task in the system.
                  Changing requires recompile of tskmain.c.
*/

#define  PRI_TIMER   0xf000

/*
   PRI_STD        standard priority of user tasks (arbitrary), for use
                  in user programs.
                  Changing requires recompile of tskmain.c.
*/

#define  PRI_STD     100

/*
   PRI_INT9       priority of the int9 task. Normally lower than or equal to
                  user defined tasks, but may be adjusted to tune responses
                  of TSR's.
                  Changing requires recompile of tskmain.c.
*/

#define  PRI_INT9    (PRI_STD - 1)

/*
   IBM            if 1, routines specific to the IBM family of PCs
                  (and clones) are installed.

   DOS            if 1, routines specific to PC/MS-DOS are installed.

      NOTE: If you disable IBM, you have to provide timer and keyboard
            hardware support yourself. Check the areas in "tskmain.c" 
            that are affected by this define.
            Changing requires recompile of tskmain.c.
*/

#define  IBM   1
#define  DOS   1


/*
   AT_BIOS        if 1, the AT BIOS wait/post handler is installed.
                  Changing requires recompile of tskmain.c.
*/

#define  AT_BIOS  1

