/*
   CPPTask - A Multitasking Kernel For C++

   TSKLOCAL.HPP - Internal definitions and prototypes.

   Version 1.0 08-12-91

   Ported by Rich Smith from:

   Public Domain Software written by
      Thomas Wagner
      Patschkauer Weg 31
      D-1000 Berlin 33
      West Germany
*/

/*
   struct task_stack describes the contents of a tasks stack after creation.
   The first 10 words are the registers to be restored by the scheduler.
   Only the segment registers are significant initially.
   The next three words contain the function address plus the CPU flags
   setup as if an interrupt had occurred at the function's entry address.

   This setup is the same as the stack of an interrupted task after
   scheduling.

   The following two words contain a dummy return address, which points
   to the routine "killretn". Thus, if the task main function should ever
   return, the task is automatically killed. The last doubleword is
   used for the optional argument to the task.
*/

struct task_stack {
   word     r_es;
   word     r_ds;
   word     r_di;
   word     r_si;
   word     r_bp;
   word     r_sp;
   word     r_bx;
   word     r_dx;
   word     r_cx;
   word     r_ax;
   funcptr  retn;
   word     r_flags;
   funcptr  dummyret;
   farptr   arg;
};

extern tcbptr    tsk_eligible;
extern tcbptr    tsk_current;
extern tlinkptr  tsk_timer;
extern byte      tsk_preempt;
extern byte      tsk_pretick;

#if (CLOCK_MSEC)
extern dword tsk_timeout (dword tout);
extern double tick_factor;
#else
#define tsk_timeout(tout)  tout
#endif

// externals from tsktim.asm

extern "C" void far tsk_install_timer (word divisor, word sys_ticks);
extern "C" void far tsk_remove_timer (void);
extern "C" void far tsk_chain_timer (void);

// externals from tskdos.asm

extern "C" void far tsk_install_dos (void);
extern "C" void far tsk_remove_dos (void);

// externals from tskkbd.asm

extern "C" void far tsk_install_kbd (void);
extern "C" void far tsk_remove_kbd (void);
extern "C" word far t_read_key (void);
extern "C" word far t_wait_key (dword timeout);
extern "C" word far t_keyhit (void);

// externals from tskbios.asm

extern "C" void far tsk_install_bios (void);
extern "C" void far tsk_remove_bios (void);

#define tsk_dseg()   _DS

// external from tskasm.asm

extern "C" word far tsk_flags (void);

extern void far tsk_wait (tqueptr que, dword timeout);


