/*
   CPPTask - A Multitasking Kernel For C++

   Version 1.0 08-12-91

   Ported by Rich Smith from:

   Public Domain Software written by
      Thomas Wagner
      Patschkauer Weg 31
      D-1000 Berlin 33
      West Germany

   TSKSUB.CPP - CTask Support Subroutines

   Subroutines:
        t_delay
        killretn
        tsk_kill_queue
        tsk_timeout
*/

#include <stdio.h>

#include "task.hpp"
#include "tsklocal.hpp"

/*
   t_delay
      delay the current task by "ticks" clock ticks.
      If ticks is zero, the task is stopped.
*/

int far t_delay (dword ticks)
{
   tsk_cli();
   tsk_current->queue = NULL;
   if (ticks)
      {
      tsk_current->state = ST_DELAYED;
      tsk_current->tsk_enqtimer (ticks);
      }
   else
      tsk_current->state = ST_STOPPED;

   tasker.schedule ();
   return (int)tsk_current->retptr;
}


/*
   Killretn kills the current active task. It is used internally, but
   can also be called from outside.
*/

void far killretn (void)
{
   tsk_cli ();
   tsk_current->tsk_kill ();
   tsk_current = NULL;
   tasker.schedule ();
}

/*
   tsk_kill_queue
      Removes all tasks from a queue. For internal use only, critical
      section assumed entered.
*/
void far tsk_kill_queue (tqueptr que)
{
   tcbptr curr;

   for (curr = *que; curr != NULL; curr = curr->get_next())
      {
      curr->tsk_unqtimer ();
      curr->tsk_kill ();
      }
   *que = NULL;
}


#if (CLOCK_MSEC)

dword tsk_timeout (dword tout)
{
   dword t;

   t = (dword) (((double)tout / tick_factor) + 0.5);
   return (t) ? t : 1; 
}

#endif

