/*
   CPPTask - A Multitasking Kernel For C++

   Version 1.0 08-12-91

   Ported by Rich Smith from:

   Public Domain Software written by
      Thomas Wagner
      Patschkauer Weg 31
      D-1000 Berlin 33
      West Germany

   TSKTIMER.CPP - Timer routines

   Subroutines:
        timer::timer
        timer::~timer
        timer::change_timer
        timer::tsk_timer_action
*/

#include "task.hpp"
#include "tsklocal.hpp"

/*
   timer
      Creates a timer queue element. The element is inserted into
      the timeout queue.
*/

timer::timer (dword tout, farptr structp, byte kind, byte rept)
{
   CRITICAL;

   tkind = kind;
   strucp = structp;
   timeout = reload = tsk_timeout(tout);

   if (kind <= TKIND_TASK || kind > TKIND_COUNTER)
      {
      tstate = TSTAT_IDLE;
      next = NULL;
      }
   else
      {
      tstate = (byte)((rept) ? TSTAT_REPEAT : TSTAT_COUNTDOWN);

      C_ENTER;
      next = tsk_timer;
      tsk_timer = this;
      C_LEAVE;
      }
}


/*
   ~timer
      Deletes a timeout element.
*/

timer::~timer ()
{
   CRITICAL;

   C_ENTER;
   if (tstate != TSTAT_IDLE)
      {
      tstate = (byte)TSTAT_REMOVE;
      C_LEAVE;
      return;
      }
   C_LEAVE;

}


/*
   change_timer
      Changes the timeout and/or repeat-flag in a timer element.
      If the timer was idle, it is inserted into the timeout queue.

      If 0 is passed as timeout, the element is removed from the
      timeout queue (same as ~timer).

      This routine should *not* be used for dynamically allocated
      timer elements.
*/

void far timer::change_timer (dword tout, byte rept)
{
   byte st;
   CRITICAL;

   if (!tout)
      {
      this->timer::~timer();
      return;
      }

   C_ENTER;
   timeout = reload = tsk_timeout(tout);
   st = tstate;
   tstate = (byte)((rept) ? TSTAT_REPEAT : TSTAT_COUNTDOWN);

   if (st == TSTAT_IDLE)
      {
      next = tsk_timer;
      tsk_timer = this;
      }
   C_LEAVE;
}



/*
   tsk_timer_action performs the necessary action when a timeout occurred.
*/

void timer::tsk_timer_action (void)
{
   tcbptr taskptr;
   byte st;

   switch (tkind & 0x7f)
      {
      case TKIND_WAKE:
      case TKIND_TASK:  taskptr = (tcbptr) strucp;
                        st = taskptr->get_state();

                        if (st == ST_WAITING || st == ST_DELAYED)
                           {
                           taskptr->set_retptr(TTIMEOUT);
                           taskptr->wake_task ();
                           }
                        break;

      case TKIND_FLAG:  ((flagptr) strucp)->set_flag ();
                        break;

      case TKIND_COUNTER: ((counterptr) strucp)->inc_counter ();
                        break;

      case TKIND_PROC:  ((funcptr) strucp)();
                        break;

      default:          break;
      }
}


