#**********************************************************************
#
#   builtins.mak - "built-in" rules for Borland MAKE utility
#
#   12/??/90    J. Alan Eldridge    created for TC 2.0
#
#   07/24/90    JAE                 revised heavily for TC++ 1.0
#
#   11/07/90    JAE                 cleaned up a bit
#                                   now uses $(TC*) environment variables
#                                   to find TC++ files
#
#   12/20/90    JAE                 modified to use a TCC configuration
#                                   file for default options
#
#                                   removed some superfluous options
#
#**********************************************************************

#   force .h file dependency checking

.AUTODEPEND

#**********************************************************************
#
#   the following symbols are defined to locate the Turbo C++
#   executables, include files, libraries, etc.
#
#   name        meaning                         example
#   ------------------------------------------------------------
#
#   TCDIR       drive & dir for tc files        D:\TC
#
#   TCINC       full include dir path           D:\TC\INCLUDE
#
#   TCLIB       full library dir path           D:\TC\LIB
#
#   TAINC       full include path for asm       D:\TASM\EX
#
#**********************************************************************


#**********************************************************************
#
#   the following symbols can be defined to affect the C++ compiler,
#   assembler, and linker options:
#
#   define these for effect (no value necessary):
#
#       SMALL, MEDIUM, COMPACT, or HUGE
#           these override default LARGE memory model
#
#   define these = 1 or = 0 to control options:
#
#       name        meaning                     default
#       --------------------------------------------------
#
#       NODBG       turn off generation         0
#                   of debug info in objs
#
#       NOSYM       no symbol table in exe      0
#
#       I286        use 186/286 instructions    0
#
#       F87         87-only floating point      0
#
#       F287        287-only floating point     0
#
#       ALIGN       word align structures       0
#
#       WILDARGS    auto *? expand in main()    0
#
#       OVERLAY     link with overlay lib       0
#
#       TCLASS      link with TC++ class lib    0
#
#       GRAPHICS    link with BGI graphics      0
#
#       NOFLOAT     do not link with math lib   0
#
#**********************************************************************

#**********************************************************************
#
#   the following symbols are defined for use by the
#   applications makefile:
#
#   MEM,CMEM        a single letter representing the C++
#                   compiler memory model (S,C,M,L,H)
#
#**********************************************************************

#**********************************************************************
# set the memory model if not already specified
#**********************************************************************

!if $(SMALL) || $(small)
CMEM=s
AMEM=__SMALL__

!elif $(MEDIUM) || $(medium)
CMEM=m
AMEM=__MEDIUM__

!elif $(COMPACT) || $(compact)
CMEM=c
AMEM=__COMPACT__

!elif $(HUGE) || $(huge)
CMEM=h
AMEM=__HUGE__

!else
CMEM=l
AMEM=__LARGE__
!endif

MEM=$(CMEM)

#**********************************************************************
#   start ASM,CC flags with memory model
#**********************************************************************

CCFLAGS=-m$(CMEM)
ASFLAGS=/d$(AMEM)

#**********************************************************************
# debug info defaults to on
#**********************************************************************

!if $(NODBG)
NOSYM=1
!else
CCFLAGS=$(CCFLAGS) -v
!endif

#**********************************************************************
# tell where to find include files
#**********************************************************************

#   INC1 ... INC3 are for app use

!if $d(INC1)
CCFLAGS=-I$(INC1) $(CCFLAGS)
ASFLAGS=/i$(INC1) $(ASFLAGS)
!endif

!if $d(INC2)
CCFLAGS=-I$(INC2) $(CCFLAGS)
ASFLAGS=/i$(INC2) $(ASFLAGS)
!endif

!if $d(INC3)
CCFLAGS=-I$(INC3) $(CCFLAGS)
ASFLAGS=/i$(INC3) $(ASFLAGS)
!endif

#**********************************************************************
# do we want 8087-only fp support?
#**********************************************************************

!if $(F87)
CCFLAGS=$(CCFLAGS) -f87
!elif $(F287)
CCFLAGS=$(CCFLAGS) -f287
!endif

#**********************************************************************
# 186/286 instructions
#**********************************************************************

!if $(I286)
CCFLAGS=$(CCFLAGS) -1
!endif

#**********************************************************************
# structure alignment (default is off)
#**********************************************************************

!if $(ALIGN)
CCFLAGS=$(CCFLAGS) -a
!endif

#**********************************************************************
# miscellaneous flags the user might want
#**********************************************************************

!if $d(CFLAGS)
CCFLAGS=$(CCFLAGS) $(CFLAGS)
!endif

#**********************************************************************
# this command runs the compiler
#**********************************************************************

TCC=bcc $(CCFLAGS)

#**********************************************************************
# here's how to compile a .c (or .cpp) to get a .obj file or a .asm file
#**********************************************************************

.c.obj:
    $(TCC) {$. }

.cpp.obj:
    $(TCC) {$. }

.c.asm:
    $(TCC) -S {$. }

.cpp.asm:
    $(TCC) -S {$. }


#**********************************************************************
# the assembler include files are here
#**********************************************************************

ASFLAGS=$(ASFLAGS) /i$(TAINC)

#**********************************************************************
# miscellaneous flags the user might want
#**********************************************************************

!if $d(AFLAGS)
ASFLAGS=$(ASFLAGS) $(AFLAGS)
!endif

#**********************************************************************
# this command runs the assembler
#**********************************************************************

ASFLAGS=$(ASFLAGS) /zi /mx /m3 /jMASM51

TASM=tasm $(ASFLAGS)

#**********************************************************************
# here's how to assemble a .asm to get a .obj file
#**********************************************************************


.asm.obj:
    $(TASM) $&,$*

.asm.lst:
    $(TASM) /l $&,nul

#**********************************************************************
#   macro to run the librarian
#**********************************************************************

TLIB=tlib /C $*.lib

#**********************************************************************
# linker debugging option
#**********************************************************************

!if $(NOSYM)
LDBG=
!else
LDBG=/v
!endif

#**********************************************************************
# macro for location of tc libraries
#**********************************************************************

!if !$d(TCLIB)
TCLIB=$(TCDIR)\lib
!endif

#**********************************************************************
# macros for full pathnames of compiler libraries
#
# if NOFLOAT is defined, then math libs will not be searched (unless
#   F87 or F287 are defined, which override NOFLOAT)
# if GRAFIX is defined, the graphics library will be searched
# if TCLASS is defined, the TC++ class libraries will be searched
# if OVERLAY is defined, the overlay support lib will be searched
#
#**********************************************************************

TCLIBS=

CSTARTUP=$(TCLIB)\c0$(CMEM)

!if $(WILDARGS)
CSTARTUP=$(CSTARTUP) $(TCLIB)\wildargs
!endif

!if $(TCLASS)
TCLIBS=$(TCLIBS) $(TCDIR)\classlib\lib\tclass$(CMEM)
!endif

!if $(GRAPHICS)
TCLIBS=$(TCLIBS) $(TCLIB)\graphics
!endif

!if $(F87)
FPLIB=$(TCLIB)\fp87
NOFLOAT=0
!elif $(F287)
FPLIB=$(TCLIB)\fp87
NOFLOAT=0
!else
FPLIB=$(TCLIB)\emu
!endif

MATHLIB=$(TCLIB)\math$(CMEM)
CLIB=$(TCLIB)\c$(CMEM)

!if $(OVERLAY)
TCLIBS=$(TCLIBS) $(TCLIB)\overlay
!endif

!if !$d(NOFLOAT) || !$(NOFLOAT)
TCLIBS=$(TCLIBS) $(FPLIB) $(MATHLIB)
!endif

TCLIBS=$(TCLIBS) $(CLIB)

#**********************************************************************
#   macro to run the linker
#********************************************************************** 

TLINK=tlink /c /s $(LDBG) $(CSTARTUP)+ 
