#include    "aedef.h"
#include    "task.h"

unsigned    _stklen = 0x4000;

class   MyTask1: public Task {
private:

    int     iter;

public:

    MyTask1(char *name, Scheduler &s): Task(name, s), iter(0)
        { }
        
private:

    void    tskMain();
    
};

class   MyTask2: public Task {
private:

    int     iter;

public:

    MyTask2(char *name, Scheduler &s): Task(name, s), iter(0)
        { }
        
private:

    void    tskMain();
    
};

void
MyTask1::tskMain()
{
    for (;;) {
        printf("task %s part 1: %d\n", name(), iter);
        int ch;
        if (kbhit() && (ch = getch()) == '1')
            signalSema("sema");
        else if (ch == 0x1B)
            endProcess();
        printf("task %s part 2: %d\n", name(), iter++);
        suspend();
   }
}

void
MyTask2::tskMain()
{
    for (;;) {
        printf("task %s part 1: %d\n", name(), iter);
        waitSema("sema");
        printf("task %s part 2: %d\n", name(), iter++);
        suspend();
   }
}

void
main()
{
    Scheduler s;
    
    MyTask1 task1("task1", s);
    MyTask2 task2("task2", s);
    
    Sema    sema("sema");
    
    s.addSema(&sema);
    
    s.run();
    exit(EXIT_SUCCESS);
}
