#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <bios.h>
#include "tsr.h"
#include "chain.h"

#define STACK_SIZE      8192
#define SET_DTA         0x1A
#define GET_DTA         0x2F
#define KBD_PORT        0x60

#define PSP_ENV_ADDR    0x2C

#define HOT_KEY         0x34
#define RIGHT_SHIFT        1
#define LEFT_SHIFT         2
#define CTRL_KEY           4
#define ALT_KEY            8

#define MULTIPLEX_ID    0xC0
#define INSTALL_CHECK   0x00
#define INSTALLED       0xFF


unsigned char MultiplexID = MULTIPLEX_ID;
unsigned SaveSS,  SaveSP;
unsigned TsrStack[STACK_SIZE/2];
int TsrAlreadyActive = 0;
int PopupWhileDosBusy= 0;
int Int28InProgress  = 0;
int UnsafeFlag       = 0;

unsigned char  HotKey;
unsigned char  ShiftKey;

unsigned ForegroundPSP;
unsigned ForegroundDTASeg;
unsigned ForegroundDTAOff;

union  REGS    regs;
struct SREGS   sregs;


typedef  void interrupt (*INTVECT)();

INTVECT OldInt08, OldInt09, OldInt13, OldInt1B;
INTVECT OldInt23, OldInt24, OldInt28, OldInt2F;


void interrupt  NewInt08(INTERRUPT_REGS);       // New ISR For Timer
void interrupt  NewInt09(INTERRUPT_REGS);       // New ISR For Keyboard
void interrupt  NewInt13(INTERRUPT_REGS);       // New ISR For Disk I/O
void interrupt  NewInt1B(INTERRUPT_REGS);       // New ISR For Ctrl-Brk
void interrupt  NewInt23(INTERRUPT_REGS);       // New ISR For Ctrl_Brk Exit
void interrupt  NewInt24(INTERRUPT_REGS);       // New ISR For Critical Err.
void interrupt  NewInt28(INTERRUPT_REGS);       // New ISR For DOS Idle
void interrupt  NewInt2F(INTERRUPT_REGS);       // New ISR For Multiplex..



extern int application(void);
void TsrFunction(void);

void interrupt NewInt08(INTERRUPT_REGS r)
{
    (*OldInt08)();
    if ( !TsrAlreadyActive &&  PopupWhileDosBusy &&
	 !DosBusy()        && !UnsafeFlag)
    {
	PopupWhileDosBusy = 00;
	TsrAlreadyActive++;
	TsrFunction();
	TsrAlreadyActive--;
    }
}



void interrupt NewInt09(INTERRUPT_REGS r)
{
    if ( !TsrAlreadyActive )
	if (inportb(KBD_PORT) == HotKey)
	    if ((bioskey(2) & ShiftKey) == ShiftKey)
		PopupWhileDosBusy = 01;
    (*OldInt09)();
}


void interrupt NewInt13(INTERRUPT_REGS r)
{
    UnsafeFlag++;               // Increment the Unsafe Flag
    (*OldInt13)();              // Call Old Handler
    r.ax    = _AX;              // Return value of AX
    r.bx    = _BX;              // Return value of BX
    r.cx    = _CX;              // Return value of CX
    r.dx    = _DX;              // Return value of DX
    r.es    = _ES;              // Return value of ES
    r.di    = _DI;              // Return value of DI
    r.flags = _FLAGS;           // Return the Flags
    UnsafeFlag--;               // Clear out Unsafe Flag
}

void interrupt NewInt1B(INTERRUPT_REGS r)
{
//   DO NOTHING
}


void interrupt NewInt23(INTERRUPT_REGS r)
{
//   DO NOTHING
}


void interrupt NewInt24(INTERRUPT_REGS r)
{
    if ( _osmajor >= 3 )
	r.ax = 3;                               // FAIL the DOS function
    else
	r.ax = 0;                               // Simply IGNORE the error
}


void interrupt NewInt28(INTERRUPT_REGS r)
{
    Int28InProgress++;
    if ( PopupWhileDosBusy && (!Int28DosBusy()) &&
	 !TsrAlreadyActive  &&  !UnsafeFlag)
    {
	TsrAlreadyActive++;
	TsrFunction();
	TsrAlreadyActive--;
    }
    Int28InProgress--;
    ChainInt( r, OldInt28 );
}


void interrupt NewInt2F(INTERRUPT_REGS r)
{
    if (_AH == MultiplexID)
	if ( _AL == INSTALL_CHECK )
	{
	    r.ax |= INSTALLED;
	    return;
	}
    ChainInt( r, OldInt2F );
}


void TsrFunction()
{
    SaveSS = _SS;
    SaveSP = _SP;
   _SS     = _DS;
   _SP     = (unsigned)(&TsrStack[(STACK_SIZE/2)-2]);

    PopupWhileDosBusy = 00;
    OldInt1B = (INTVECT)getvect(0x1B);
    OldInt23 = (INTVECT)getvect(0x23);
    OldInt24 = (INTVECT)getvect(0x24);

    setvect(0x1B, (void interrupt (*)(...))NewInt1B);
    setvect(0x23, (void interrupt (*)(...))NewInt23);
    setvect(0x24, (void interrupt (*)(...))NewInt24);

    ForegroundPSP = GetPSP();
    SetPSP(_psp);

    _AH = GET_DTA;
    geninterrupt(0x21);
    ForegroundDTAOff = _BX;
    ForegroundDTASeg = _ES;

    regs.h.ah = SET_DTA;
    regs.x.dx = 0x80;
    sregs.ds  = _psp;
    intdosx(&regs, &regs, &sregs);

    while( bioskey(1) )
	bioskey(0);

    application();

    regs.h.ah = SET_DTA;
    regs.x.dx = ForegroundDTAOff;
    sregs.ds  = ForegroundDTASeg;
    intdosx(&regs, &regs, &sregs);
    SetPSP(ForegroundPSP);
    setvect(0x1B, (void interrupt (*)(...))OldInt1B);
    setvect(0x23, (void interrupt (*)(...))OldInt23);
    setvect(0x24, (void interrupt (*)(...))OldInt24);

    _SS = SaveSS;
    _SP = SaveSP;
}



#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
unsigned _heaplen = 512;
#endif

int main(int argc, char *argv[])
{
    InitInDos();
    _AH = MultiplexID;
    _AL = INSTALL_CHECK;
    geninterrupt( 0x2F );
    if ( _AL == INSTALLED )
    {
	puts("Resident Copy of TSR already in Memory");
	puts("Press ALT-. to active resident copy.");
	exit( 1 );
    }

    puts("Press ALT-. to activate TSR ");
    printf("Multiplex ID = %0X \n", MultiplexID);

    HotKey   = HOT_KEY;
    ShiftKey = ALT_KEY;

    OldInt08 = (INTVECT)getvect(0x08);
    OldInt09 = (INTVECT)getvect(0x09);
    OldInt13 = (INTVECT)getvect(0x13);
    OldInt28 = (INTVECT)getvect(0x28);
    OldInt2F = (INTVECT)getvect(0x2F);

    setvect(0x08, (void interrupt (*)(...))NewInt08);
    setvect(0x09, (void interrupt (*)(...))NewInt09);
    setvect(0x13, (void interrupt (*)(...))NewInt13);
    setvect(0x28, (void interrupt (*)(...))NewInt28);
    setvect(0x2F, (void interrupt (*)(...))NewInt2F);

    freemem(*((unsigned far *)MK_FP(_psp, PSP_ENV_ADDR)));
    keep(0, *((unsigned far *)MK_FP((_psp-1),  03)));
    return (0);
}
