/* ------------------------------------------------------------------------- *
 * CPUTYPE.C  CPU/FPU detection routines				     *
 *									     *
 * Copyright(c) 1994,95 by B-coolWare.  Written by Bobby Z. and VAP.	     *
 * Uses portions of TMi0SDGL(tm) v1.15					     *
 * ------------------------------------------------------------------------- *
 * files needed to build:
   
   CPUTYPE.C		- compile with memory model XXX
   CPU_HL.ASM		- set memory model to XXX
   CPUSPEED.ASM		- set memory model to XXX
   P5INFO.ASM		- set memory model to XXX
   SMM.ASM		- set memory model to XXX
*/

#include <stdlib.h>
#include <string.h>

#define __Lib__
#include "cputype.h"

byte pascal FPUType = 0xFF;	/* variable to keep FPU test result code */
long pascal CPUFix  = 0L;	/* variable used internally in CPU speed testing */
word pascal Shift   = 2;	/* --"-- */

#ifdef __cplusplus
extern "C" {
#endif
extern int pascal Speed( byte );	     /* returns raw CPU speed factor */
extern word pascal GetP5Features(void);	     /* returns P5 feature word */
extern void pascal GetP5Vendor(char far *);  /* returns CPU vendor id string */
extern word pascal CheckP5(void);	     /* checks if cpuid works */
#ifdef __cplusplus
}
#endif

void pascal checkUMC(void)
{
 char s[14];
 if(__CPU >= i486sxr)
  if(CheckP5()==0x423)
   {
    GetP5Vendor(s);
    s[13]=0;
    if(strstr(s+1,"UMC")!=0L)
     if(GetP5Features() & 1)
      __CPU = 0x14;
     else
      __CPU = 0x13;
   }
}

float pascal CPU_Speed(void)
{
 word sp;
 if(!__CPU)
  return 0;
 sp = Speed(__CPU);
 return (((long)Shift*CPUFix)/sp+5)/10;
}

int pascal intCPU_Speed(void)
{
 long sp;
 if(!__CPU)
  return 0;
 sp = (long) Speed(__CPU);
 return (int) ((((long)Shift*CPUFix)/sp+5l)/10l);
}

static char *cpuNames[] = {"Intel 8088", "Intel 8086", "NEC V20", "NEC V30",
		           "Intel 80188", "Intel 80186", "Intel 80286", "Intel 80386SX",
		           "Intel 80386DX", "IBM 386SL", "Intel i486SX", "Intel i486DX",
		           "Cyrix 486SLC", "Cyrix 486", "Intel Pentium", "Cyrix M1 (586)",
		           "Intel P24D (Pentium Overdrive)","AMD Am386SX","AMD Am386DX",
                           "UMC U5-S","UMC U5-D"
		   };

static char *cpuModels[] = {"DX","DX","SX","DX2/Overdrive","SL","SX2","","","DX4","","","","","","","" };


char * pascal cpuType_Str(void)
{
  word c = CPU_Type();
  __CPU = c;
  checkUMC();
  if (__CPU == 0x0A && (c>>12))
   return strcat("Intel i486",cpuModels[c >> 12]);
  switch(c) {
   case i80386sxr:
   case i80386sxv: if (intCPU_Speed() > 35)
 		    return cpuNames[0x11];
		   else
	 	    return cpuNames[__CPU];
   case i80386dxr:
   case i80386dxv: if (intCPU_Speed() > 35)
		    return cpuNames[0x12];
		   else
		    return cpuNames[__CPU];
   default:
	           return cpuNames[__CPU];
  }
}

static char *fpuNames[] = {"Unknown!", "Unknown!", "None", "Weitek", "Intel 8087",
		           "Intel 8087 & Weitek", "Intel i487sx", "Intel i487sx & Weitek",
		           "Intel 80287", "Intel 80287 & Weitek", "Cyrix 2C87",
		           "Cyrix 2C87 & Weitek", "Intel 80387", "Intel 80387 & Weitek",
		           "Cyrix 3C87", "Cyrix 3C87 + Weitek", "Built-in",
		           "Built-in & Weitek", "Cyrix 4C87", "Cyrix 4C87 & Weitek",
		           "Intel 80287XL", "Intel 80287XL & Weitek",
		           "IIT 2C87", "IIT 2C87 & Weitek", "IIT 3C87", "IIT 3C87 & Weitek"
		           };


char * pascal fpuType_Str(void)
{

  int c = CPU_Type();
  if (FPUType > 25) 
   return ("Unknown!");
  else
   if ((c >= i80286) && checkEmu())
    return strcat(fpuNames[FPUType],", Emulated");
   else
    return fpuNames[FPUType];
}
