/***********************************************************************

                                      CSDB Library, Version 1.6.b 
                                         Released: March 2nd 1995 

       Foundation class.
       Supplies buffered disk IO on a page-by-page
       bases.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSPAGE_H
#define __CSPAGE_H

#ifndef __CSBUFF_H
#include "csbuff.h"
#endif

#include "csbase.h"


/**************************************************************************/
class PAGE: public BASE, public BUFFER
{
protected:
   U32	pc_empty;   // Page Chain Empty
   U32	pn_empty;   // Number of pages empty.

protected:

   int	read_header(void);
   int	write_header(void);
   int	hread(void *buf,int size);
   int	hwrite(void *buf,int size);
   int	close2(void);
   int	user_2_data(void *buf,U32 amount);
   int	data_2_user(void *buf,U32 amount);
   int	fseek(U32 l)		  { return ::fseek(fp,l,SEEK_SET); }
   void init_vars(void);
   void init_defaults(void);
   void init_allocs(void);
   int	zap(void);
   void name(CSCHAR *s) 	  { BUFFER::name(s); BASE::name(s); }
   void emergency_exit(void);
   U32	unfree_page(void);
   virtual void check_id(U32 id);
   virtual void set_id(void);


public:
   PAGE(void);
   ~PAGE(void);

//////////////////////// Definition //////////////////////////////////////////
/* Inherited
   void page_size(U16 t)
   U16	page_size(void)
   U16	foot_size(void)
   void foot_size(int size)   */

   int	define(CSCHAR *name,U16 pagesize);
   int	define(CSCHAR *name)	  { return define(name,lenpage); }

//////////////////////// Buffering ///////////////////////////////////////////
/* INHERITED
   void number_buff_min(uint nr)
   void number_buff_max(uint nr)
   void number_buff(uint mini,uint maxi);
*/
//////////////////////// Open & Close ////////////////////////////////////////
   int	open(CSCHAR *name,S16 kB=32);
   int	close();
   int	save(void);
   int	save_as(CSCHAR *s);

//////////////////////// Locate & Load Pages /////////////////////////////////
   CSCHAR *locate_page_d(U32 page)  { return (CSCHAR *)locate_buff_d(page); }
   CSCHAR *locate_page(U32 key,int prior,int rwl) { return (CSCHAR *)locate_buff(key,prior,rwl); }
   CSCHAR *load_page(U32 page)	    { return (CSCHAR *)load_buff(page); }
   CSCHAR *load_page_d(U32 page)    { return (CSCHAR *)load_buff_d(page); }
   CSCHAR *load_page_l(U32 page)    { return (CSCHAR *)load_buff_l(page); }
   CSCHAR *load_page_ld(U32 page)   { return (CSCHAR *)load_buff_ld(page); }
   void *load_page(U32 key,int prior,int rwl)	 { return (CSCHAR *)load_buff(key,prior,rwl);  }
   void locate_double(U32 r1,CSCHAR* &p1,U32 r2,CSCHAR* &p2);
   void locate_double_d(U32 r1,CSCHAR* &p1,U32 r2,CSCHAR* &p2);

//////////////////////// Read & Write Pages //////////////////////////////////
   void read_page( U32 l,void *p)  { memcpy(p,load_page(l),lenpage); }
   void write_page( U32 l,void *p) { memcpy(locate_page_d(l),p,lenpage); }

//////////////////////// New Pages ///////////////////////////////////////////
   U32	new_page(void)		    { return ((pc_empty) ? unfree_page(): add_page()); }
   U32	add_page(void);
   void free_page(U32 num);
   U32	nr_empty(void)		    { return pn_empty; }

//////////////////////// Number of Pages /////////////////////////////////////
/* Inherited
   U32 num_page(void) */
   void set_num_page(U32 n)  { BASE::set_num_page(n); BUFFER::set_num_page(n); }

//////////////////////// Pages Status ////////////////////////////////////////
   int	is_dirty_page( U32 page)    { return BUFFER::is_dirty(page); }
   void set_dirty_page(void *p	)   { BUFFER::dirty(p);    }
   void set_dirty_page(U32 page)    { BUFFER::dirty(page); }
   void reset_dirty_page(void *p)   { BUFFER::clean(p);    }
   void reset_dirty_page(U32 page)  { BUFFER::clean(page); }

/* Inherited
   void change_stat(void *page,int prior,int stat);
   void change_stat(void *page,int prior);
   int	priority(void *page);					      */

//////////////////////// Data in Header Page /////////////////////////////////
   int	data_2_header(void * ptr,U16 length);
   int	header_2_data(void * ptr,U16 length);
   U16	max_data_in_header(void);

//////////////////////// Report Writing //////////////////////////////////////
   int	report(CSCHAR *name,int sub=1);
   void report(FILE *fipo,int sub);

////////////////////////// Miscellaneous ///////////////////////////////////////
/* Inherited
   U16	page_free(void)
   int	background(void)
   int	in_ram(U32 key);					  */
   int	empty(void);
   virtual int class_ID(void)  { return 11; }


};


#endif
