/****************************************************************
* FILE:	define.h
* DESC:	These are the main defines for dissolve, warp, 
*		morph, load and fix.
* 
* HISTORY:	Created	 7/06/1994
* LAST CHANGED:  7/06/1994
* 
*	Copyright (c) 1994 by Scott Anderson
*
****************************************************************/

/* ----------------------DEFINES------------------------------ */

#define ON				1
#define OFF				0

#define MAX_TWEENS		99		/* Maximum tweens (2 digits) */
/* minus 2 digit tween# appended to end */
#define MAX_NAME_SIZE	(8-2)	

#define HEADER_LEN		128		/* PCX header length */
/* Number of colors in the palette */
#define COLORS			256		
/* bytes in palette (COLORS*3) */
#define PALETTE_SIZE	(3*COLORS)	

/* Maximum number of morphing lines */
#define MAX_LINES		32		
/* max number of pixels wide we handle */
#define MAX_WIDE		320		
/* max number of pixels tall we handle */
#define MAX_TALL		200		
/* Size of screen buffer */
#define	MAX_BYTES		(MAX_WIDE*(long) MAX_TALL)	
/* Number of components per color (RGB) */
#define COMPS			3		
/* largest color component value */
#define MAX_COMP		32		
/* the midpoint of the colors - for gray */
#define MID_COMP		(MAX_COMP/2)	
/* enough to handle about 10 different palettes */
#define MAX_FREQ 		1023	
#define MAX_FILES		10
/* length of a file name including directory */
#define MAX_PATHLEN     80      

#define ENTER			13		/* Keyboard values */
#define	ESC				27

#define HTAB			18		/* Position for text messages */
#define VTAB			8

/* The mouse button & keyboard constants */
#define NO_BUTTON		0		
#define LEFT_BUTTON		1
#define RIGHT_BUTTON	2
#define KEYPRESS		4

/* the square of min dist for grabbing pt */
#define GRAB_DISTANCE	25		

/* Some of the graphics colors */
#define	BLACK			0		
#define WHITE			255

#define EXT_PCX         ".PCX"	/* pcx file extension */
/* primary line file holder extension */
#define EXT_LINE1		".LN1"	
#define EXT_LINE2		".LN2"	/* aux file for warp lines */

#define ERROR 			-1		/* General-purpose error code */

typedef enum {
	NO_ERROR,			/* first entry means everything is ok */
	MEMORY_ERR,			/* Not enough memory */
	READ_OPEN_ERR, 		/* Couldn't open file for reading */
	READ_ERR,	  		/* Trouble reading the file */
	WRITE_OPEN_ERR,		/* Couldn't open the file for writing */
	WRITE_ERR,	  		/* Couldn't write the file */
	MOUSE_ERR,	  		/* No mouse driver found */
	WRONG_PCX_FILE,		/* PCX file format not supported yet */
	READ_CONTENTS_ERR   /* error in .LN file */
}
ERR;

/* -----------------------MACROS------------------------------ */

#define MIN(a,b)		(((a)<(b)) ? (a) : (b))
#define PIXEL(p,x,y)	(p->pixmap[y * (long) p->wide + x])
#define SQUARE(x) 		(((long) x)*(x))

/* ----------------------TYPEDEFS----------------------------- */

typedef struct {
	int x,y;   			/* the screen coordinates of the point */
}
POINT;

typedef struct {
	POINT p[2];
}
LINE_SEGMENT;

typedef struct {
	int number;		/* number of segments to follow */
	LINE_SEGMENT line[MAX_LINES];
	char *filename;	/* name of file holding the line list */
}
LINE_LIST;


typedef struct {
	POINT p[2];				/* the endpoints */
	int delta_x, delta_y;	/* x & y displacement */
	float length;		/* the precalculated length of the line */
	long length_square;		/* the length squared */
}
LINE;

typedef struct {
	/* red, green, and blue color components */
	unsigned char r, g, b;	
}
COLOR;

typedef struct {
	COLOR c[COLORS];		/* a 256 entry palette */
}
PALETTE;

typedef struct {
	int xmin, ymin;			/* the upper left corner */
	int xmax, ymax;			/* the lower right corner */
	int wide, tall;			/* the width and height */
	int pal_id;				/* an ID number for each palette */
	PALETTE pal;			/* the actual palette is here */
	unsigned char far *pixmap;	/* a pointer to the pixel map */
}
PICTURE;

typedef struct linko {
	struct linko *next;
	char        *str;
}
LINKED_LIST;

/* ----------------------PROTOTYPES--------------------------- */

/**** file handling routines ****/
extern PICTURE	*loadPicture(char *filename);
extern int		loadPalette(FILE *fp, PALETTE *palette);
extern int		getBlock (unsigned char *byte, int *count, 
													FILE *fp);
extern int		mustRead(FILE *fp, char *buf, int n);
extern int		saveScreen(PALETTE *pal);
extern int		putBlock(unsigned char num, unsigned char color, 
													FILE *fp);
extern int		writeByte(unsigned char *byte, FILE *fp);

/**** screen and color routines ****/
extern int		defaultPalette(PALETTE *palette);
extern int		setPalette(PALETTE *palette);
extern int		displayPicture(PICTURE *picture);
extern int		displayNoPal(PICTURE *picture);
extern int		freePicture(PICTURE *pic);

/**** mouse routines ****/
extern int		initMouse();
extern int		hideMouse();
extern int		showMouse();
extern int		mousePos(int *x, int *y);

/**** general purpose routines ****/
extern int		clip(int num, int min, int max);
extern int		quitCheck();
extern void		quit(int err, char *name);
extern int		wait(int count);
extern int		waitForKey();
extern char		lineAsk(char *name);

/* ----------------------GLOBAL DATA-------------------------- */

extern int		TargFlag;
extern int		Key;

