/****************************************************************
* FILE:	fix.c
* DESC:	This program inputs a list of pictures, creates a best
*		fit palette, remaps the pictures, and writes them out.
* 
* HISTORY:	Created	 7/06/1994
* LAST CHANGED: 7/06/1994
* 
*	Copyright (c) 1994 by Scott Anderson
*
****************************************************************/

/* ----------------------INCLUDES----------------------------- */

#include <conio.h>
#include <stdio.h>
#include <io.h>
#include <math.h>
#include <graph.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>

#include "define.h"

/* ----------------------EXTERNALS---------------------------- */

extern LINKED_LIST	*rootSequence(int argc, char *argv[]);

/**** color routines ****/
extern int		closestColor(int r, int g, int b, PALETTE *pal);
extern void		collapseColors(PALETTE *palPtr);
extern int		mergePalette(PICTURE *pic);
extern int		remapPicture(PICTURE *picPtr, PALETTE *palPtr);

/**** line routines ****/
extern int		getLine(int *argx1, int *argy1,
						int *argx2, int *argy2);
extern int		movePoint();
extern int		setLength(LINE *line);

/**** other variables ****/ 

extern char		*OutFilename;

/* set from last picture loaded */
extern int		Xmin, Ymin, Xmax, Ymax;

/* ----------------------GLOBAL DATA-------------------------- */

PICTURE *Src;		/* source & destination picture pointers */

/***** variables used to compute intermediate images ****/

/* number of colors in tweened image before reduction*/
extern int 	Ncolors;
/* r, g, b frequency counter array */
extern unsigned int far Freq[MAX_COMP][MAX_COMP][MAX_COMP];

/* tweened images red, grn, and blu components*/
extern unsigned char far Red[MAX_WIDE][MAX_TALL];
extern unsigned char far Grn[MAX_WIDE][MAX_TALL];
extern unsigned char far Blu[MAX_WIDE][MAX_TALL];

extern PALETTE TweenPal;			/* resulting palette */

/*****************************************************************
* FUNC: main (int argc, char *argv[])
* 
* DESC: Read in a list of filenames to load, change their palettes
*		to the best-fit palette, and write them out.
*****************************************************************/

main (int argc, char *argv[])
{
	int		file;
	LINKED_LIST *pcxList, *pcxListHead;

	/* load the pcx file if one is given */
	if (argc < 3) {
		printf("Usage: fix <infile> <outfile>\n\n");
		printf("Where: <infile>  is the input sequence name\n");
		printf("       <outfile> is the output sequence name\n");
		exit(0);
	}
	OutFilename = argv[argc-1];
	initFreq();
	pcxListHead =  rootSequence(argc-1, argv);
	for (pcxList = pcxListHead; pcxList; pcxList=pcxList->next) {
		printf("Loading the file %s\n", pcxList->str);
		Src = loadPicture(pcxList->str);
		if (Src == NULL)
			quit(MEMORY_ERR, "");

		mergePalette(Src);
		freePicture(Src);
	}
	collapseColors(&TweenPal);
	setGraphicsMode();
	setPalette(&TweenPal);

	for (pcxList = pcxListHead; pcxList; pcxList=pcxList->next) {
		Src = loadPicture(pcxList->str);
		if (Src == NULL)
			quit(MEMORY_ERR, "");

		remapPicture(Src, &TweenPal);
		displayNoPal(Src);
		saveScreen(&TweenPal);
		freePicture(Src);
	}
	setTextMode();
}

