/*
	csdemo.cpp
	5-28-91
	class stream demo

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.
	CIS: 73757,2233

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072
	USA (703) 759-3838

*/


#include <string.h>
#include <fstream.h>
#include <cstream.hpp>



#define MAX_STR_BUF  80

class Employee : StreamableClass {
	char *name, *address, *cityStateZip;
static char nameBuf[], addressBuf[], cityStateZipBuf[];
public:
	StreamableClassID(2);
	Employee(char *name, char *address,
		char *cityStateZip)
		: StreamableClass(CLASS_ID)
	{
		this->name = strdup(name);
		this->address = strdup(address);
		this->cityStateZip = strdup(cityStateZip);
	}

	~Employee() { delete name; delete address;
		delete cityStateZip; }
};

char Employee::nameBuf[MAX_STR_BUF];
char Employee::addressBuf[MAX_STR_BUF];
char Employee::cityStateZipBuf[MAX_STR_BUF];

void Employee::store(ostream& os)
{
	os << name << endf << address << endf
		<< cityStateZip << endf;
}


StreamC Employee::load(istream& is, StreamC C)
{
	char *name, *address, *cityStateZip;

	if (C)
		return C;
	is.getline(nameBuf,MAX_STR_BUF,
		StreamableClass::FieldTermChar);
	is.getline(addressBuf,MAX_STR_BUF,
		StreamableClass::FieldTermChar);
	is.getline(cityStateZipBuf,MAX_STR_BUF
		,StreamableClass::FieldTermChar);
	return new Employee(nameBuf,addressBuf,
		cityStateZipBuf);
}



class Product : StreamableClass {
	char *name, * type;
	unsigned price;
static char nameBuf[], typeBuf[];
static unsigned priceBuf;
public:

	StreamableClassID(3);
	Product(char *name, char *type, unsigned price)
		: StreamableClass(CLASS_ID)
	{
		this->name = strdup(name);
		this->type = strdup(type);
		this->price = price;
	}
	~Product() { delete name; delete type; }
};

char Product::nameBuf[MAX_STR_BUF];
char Product::typeBuf[MAX_STR_BUF];
unsigned Product::priceBuf;

void Product::store(ostream& os)
{
	os << name  << endf << type << endf
		<< price << endf;
}

StreamC Product::load(istream& is, StreamC C)
{
	if (C)
		return C;
	is.getline(nameBuf,MAX_STR_BUF
		,StreamableClass::FieldTermChar);
	is.getline(typeBuf,MAX_STR_BUF
		,StreamableClass::FieldTermChar);
	is >> priceBuf;
	is.get();  // field term char
	return new Product(nameBuf,typeBuf,priceBuf);
}



StreamableClasses(20);




main()
{



	RegisterClass(StreamableClass);
	RegisterClass(Employee);
	RegisterClass(Product);



	Employee e1("Frank Borland","Sierra Nevada Mts.",
		"California");
	Employee e2("Philippe Kahn","1800 Green Hills Road",
		"Scotts Valley, CA 95067");
	Employee e3("Mike Slater","1700 Green Hills Road",
		"Scotts Valley, CA 95067");

	Product  p1("Borland C++","Language",99);
	Product  p2("Quatro Pro 3.0","Business/GUI",99);
	Product  p3("Paradox Engine 2.0","Applications",99);

	cout << "Stream three Employee Records\n" << endl;
	cout << e1 << e2 << e3 << "press enter ... " << flush;
	cin.get(); cout << endl;
	cout << "Stream three Product Records\n" << endl;
	cout << p1 << p2 << p3 << "press enter ... " << flush;
	cin.get(); cout << endl;

	ofstream oS("emp$prod.cls");
	if (!oS)
		return 1;

	oS << p1 << e2 << p3 << e1 << p2 << e3;
	oS.close();

	ifstream iS("emp$prod.cls");
	if (!iS)
		return 2;

	StreamableClass *S1, *S2, *S3;

	iS >> S1 >> S2 >> S3;
	cout << "Stream three classes\n" << endl;
	cout << S1 << S2 << S3 << "press enter ... " << flush;
	cin.get(); cout << endl;
	delete S1; delete S2;  delete S3;

	iS >> S1 >> S2 >> S3;
	cout << "Stream three more classes\n" << endl;
	cout << S1 << S2 << S3 << "press enter ... " << flush;
	cin.get(); cout << endl;
	delete S1; delete S2; delete S3;

	return 0;
}
