/*

	cstream.cpp
	5-28-91
	class stream

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.
	CIS: 73757,2233

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072
	USA (703) 759-3838

*/

#include <cstream.hpp>

char StreamableClass::FieldTermChar = '\n';


// end of field manipulator

ostream& endf(ostream& os)
{
	return os << StreamableClass::FieldTermChar
		<< flush;
}


void StreamRegistry::reg(unsigned id, StreamC (*loader)
	(istream& is, StreamC C))
{
	unsigned i;

	for (i = 0; i < count; i++)
		if (recs[i].id == id)
			break;
	if (i < count)
		if (recs[i].load == loader)
			return;
		else {
			error("StreamRegistry id "
				"conflict: ",id);
			abort();
		}
	if (count < limit)  {
		recs[count].id = id;
		recs[count].load = loader;
		count++;
	}
	else  {
		error("StreamRegistry overflow, id: ",id);
		abort();
	}
}

istream& StreamRegistry::get(istream& is, StreamC& C)
{
	unsigned id, sizeofClass, i;

	C = StreamC0;
	if (!(is >> id))
		return is;
	if (!is.get()) // field term char
		return is;
	for (i = 0; i < count; i++)
		if (recs[i].id == id)
			break;
	if (i >= count)  {
		error("StreamRegistry, attempted load "
			"of unknown class: ",id);
		return is;
	}
	C = (*recs[i].load)(is,StreamC0);
	return is;
}

ostream& StreamRegistry::put(ostream& os, StreamC C)
{
	unsigned id, i;

	if (!C)
		return os;
	id = C->ID();
	for (i = 0; i < count; i++)
		if (recs[i].id == id)
			break;
	if (i >= count)  {
		error("StreamRegistry, attempted store "
			"of unknown class: ",id);
	}
	else  {
		os << id << endf;
		C->store(os);
	}
	return os;
}
