/*

	cstream.hpp
	5-28-91
	class stream

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.
	CIS: 73757,2233


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072
	USA (703) 759-3838

*/

#ifndef CSTREAM_HPP
#define CSTREAM_HPP


#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>

class StreamableClass;
typedef StreamableClass *StreamC;
#define StreamC0 ((StreamC)0)


class StreamableClass  {
	unsigned id;
public:
static  char FieldTermChar;
	enum { CLASS_ID = 1 };
	unsigned ID() { return id; }
	operator StreamC() { return (StreamC)this; }
	virtual void store(ostream& os);
	static StreamC load(istream& is, StreamC C);
	StreamableClass(unsigned id = CLASS_ID)
		{ this->id = id; }
	virtual ~StreamableClass() {}
};

extern ostream& endf(ostream& os);


#pragma argsused
inline void StreamableClass::store(ostream& os) {}

#pragma argsused
inline StreamC StreamableClass::load(istream& is, StreamC C)
	{ return (C? C : new StreamableClass()); }

#define StreamableClassID(id)  \
	enum { CLASS_ID = id };  \
	StreamableClass::ID;          \
	operator StreamC() { return (StreamC)this; }  \
	virtual void store(ostream& os);             \
	static StreamC load(istream& is, StreamC C)




typedef struct {
	unsigned id;
	StreamC (*load)(istream& is, StreamC C);
} StreamRecord;


class StreamRegistry  {
static StreamRecord recs[];
static unsigned count, limit;
public:
	StreamRegistry()  { count = 0; }
	void reg(unsigned id, StreamC (*loader)
		(istream& is, StreamC C));
	istream& get(istream& is, StreamC& C);
	ostream& put(ostream& os, StreamC C);
	virtual void error(char *msg, unsigned id)
		{ cerr << msg << id << endl; }
};

extern StreamRegistry SR;

#define StreamableClasses(ClassCount)  \
	StreamRecord StreamRegistry::recs[ClassCount]; \
	unsigned StreamRegistry::count = 0; \
	unsigned StreamRegistry::limit = ClassCount; \
	StreamRegistry SR;

#define RegisterClass(ClassName)  \
	SR.reg(ClassName::CLASS_ID, \
	ClassName::load)



inline istream& operator>>(istream& is, StreamC& C)
{
	return SR.get(is,C);
}

inline ostream& operator<<(ostream& os, StreamC C)
{
	return SR.put(os, C);
}

#endif
