#define STRICT
#define WIN31


#include <owl.h>
#include <dialog.h>
#include <listbox.h>
#include <button.h>
#include <static.h>
#include <bwcc.h>


_CLASSDEF( TMainDlg )
_CLASSDEF( TMainApp )


class TMainDlg : public TDialog
{
    public:
        TMainDlg( PTWindowsObject, LPSTR, PTModule AModule = NULL );
        virtual ~TMainDlg();
        virtual LPSTR GetClassName();
        virtual void  GetWindowClass( WNDCLASS& );
        virtual void  SetupWindow();
};



TMainDlg::TMainDlg( PTWindowsObject AParent, LPSTR AName, PTModule AModule )
        : TDialog(  AParent, AName, AModule )
{
}


TMainDlg::~TMainDlg()
{
}


LPSTR TMainDlg::GetClassName()
{
    return "bordlg_!MainDlg!ClassName";
}


void TMainDlg::GetWindowClass( WNDCLASS& AWndClass )
{
    TDialog::GetWindowClass( AWndClass );
    AWndClass.lpfnWndProc = BWCCDefDlgProc;
    AWndClass.hIcon = LoadIcon( GetApplication()->hInstance,
                                MAKEINTRESOURCE( ID_APPICON ));
}


void TMainDlg::SetupWindow()
{
    RECT  rc;

    TDialog::SetupWindow();
    GetWindowRect( HWindow, &rc );
    OffsetRect( &rc, -rc.left, -rc.top );
    MoveWindow( HWindow,
                (( GetSystemMetrics( SM_CXSCREEN ) -
                   rc.right ) / 2 + 4 ) & ~7,
                 ( GetSystemMetrics( SM_CYSCREEN ) -
                   rc.bottom ) / 2,
                   rc.right, rc.bottom, 0 );
}



class TMainApp : public TApplication
{
    public:
        TMainApp( LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
                  LPSTR lpCmd, int nCmdShow);
        TApplication(AName, hInstance, hPrevInstance, lpCmd, nCmdShow)
        {};
        virtual void InitMainWindow();
        virtual BOOL ProcessAppMsg( LPMSG AMessage);
};



TMainApp::TMainApp( LPSTR AName, HINSTANCE hInstance, 
                    HINSTANCE hPrevInstance, LPSTR lpCmd, int nCmdShow ):
TApplication( AName, hInstance, hPrevInstance, lpCmd, nCmdShow )
{
}


void TMainApp::InitMainWindow()
{
    BWCCGetVersion();
    MainWindow = new TMainDlg( NULL,  MAKEINTRESOURCE( ID_MAINDLG ));
}



int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmd, int nCmdShow )
{
    TMainApp  MyApp( APPNAME, hInstance, hPrevInstance, lpCmd, nCmdShow );
    MyApp.Run();
    return( MyApp.Status );
}
