/**********************************************************************/
/*                  Dlgmain.cpp by Bob Bourbonnais                    */
/*              released to the public domain 12/12/91                */
/*            This program shows how to make a dialog box             */
/*                      into the main window.                         */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include <bwcc.h>

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };


class TTestDialog : public TDialog
{
public:
  TTestDialog(PTWindowsObject AParent, LPSTR AName)
    : TDialog(AParent, AName) {};
  virtual LPSTR GetClassName();
  virtual void GetWindowClass( WNDCLASS _FAR & aclass );

};


LPSTR TTestDialog::GetClassName()
{
  return "bordlg_TestDialog";
}



void TTestDialog::GetWindowClass ( WNDCLASS _FAR & aclass )
{
   TDialog::GetWindowClass( aclass );
   aclass.lpfnWndProc = BWCCDefDlgProc;
   aclass.hIcon = LoadIcon(GetApplication()->hInstance,"myicon");
}


void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TTestDialog(NULL, "MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  BWCCGetVersion();
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
