//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
/*---------------------------------------------------------*/
/*                                                         */
/*   MakeRez.cpp                                           */
/*   Creates a MyDialog (derives from TDialog) Resource    */
/*                                                         */
/*   based on Turbo Vision Hello World Demo Source File    */
/*---------------------------------------------------------*/
#define Uses_TObject
#define Uses_TKeys
#define Uses_TApplication
#define Uses_TEvent
#define Uses_TRect
#define Uses_TDialog
#define Uses_TStaticText
#define Uses_TButton
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TStreamableClass
#define Uses_TResourceFile
#define Uses_TResourceCollection
#define Uses_MsgBox
#define Uses_fpstream








#include <tv.h>


__link(RWindow);
__link(RGroup);
__link(RDialog);
__link(RFrame);
__link(RResourceCollection);
__link(RCluster);
__link(RStaticText);
__link(RButton);

#include <string.h>
#include <stdlib.h>




const char rezFileName[] = "MY.REZ";


const GreetThemCmd = 100;

/*==================START MyDialog Functions================================*/

class MyDialog: public TDialog
{
  virtual const char* streamableName() const
  {
   return "MyDialog";
   }
 protected:
  virtual void *read( ipstream& );
  virtual void write( opstream& );
  MyDialog(  StreamableInit s):TDialog(streamableInit),
	     TWindowInit( &MyDialog::initFrame ){};
 public:
 static const char* const name;
 static TStreamable* build();
 MyDialog(TRect& r, char* str ):TDialog( r, str ),
	 TWindowInit( &MyDialog::initFrame ){};
 virtual void handleEvent( TEvent& event );
 };

const char* const MyDialog::name = "MyDialog";


void* MyDialog::read( ipstream& is )
{
 TDialog::read( is );
 return this;
}
TStreamable* MyDialog::build()
 {
  return new MyDialog( streamableInit );
  }

void MyDialog::write( opstream& os)
{
  TDialog::write( os );
}

TStreamableClass RMyDialog( MyDialog::name,
			      MyDialog::build,
			      __DELTA(MyDialog)
			      );



void MyDialog::handleEvent(TEvent& event)
{
    if( event.what == evCommand )
	{
	switch( event.message.command )
	    {
	    default:
		break;
	}
    }
  // pass on the event...
  TDialog::handleEvent(event);
}
/*======================END MyDialog functions ============================*/



void makerez()
{
 fpstream *ofps=0;


 cout<< "Creating "<< rezFileName << endl;

 ofps = new fpstream( rezFileName, ios::out|ios::binary );
 if( !ofps->good() )
  {
    cerr<< rezFileName <<": init failed..."<<endl;
    exit(1);
  }

 TResourceFile *myRez;
 myRez = new TResourceFile( ofps );
 if( !myRez )
 {
   cerr<< "Resource file init failed..."<<endl;
   exit(1);
 }
// make the mydialog for future use as a resource...
   MyDialog *d = new MyDialog(TRect( 25, 5, 55, 16 ), "Hello, World!" );

   d->insert( new TStaticText( TRect( 3, 5, 15, 6 ), "How are you?" ) );
   d->insert( new TButton( TRect( 16, 2, 28, 4 ), "Zerrific", cmCancel, bfNormal ) );
   d->insert( new TButton( TRect( 16, 4, 28, 6 ), "Ok", cmCancel, bfNormal ) );
   d->insert( new TButton( TRect( 16, 6, 28, 8 ), "Lousy", cmCancel, bfNormal ) );
   d->insert( new TButton( TRect( 16, 8, 28, 10 ), "Cancel", cmCancel, bfNormal ) );

  // deskTop->execView( d );
  // instead of inserting, put the resource file...
  if( !d )
  {
   cerr<< "Dialog init failed..."<<endl;
   exit(1);
   }

  myRez->put( d, "Zebra"); //unique name for index
  TObject::destroy( d );
  TObject::destroy( myRez);
  }








int main()
{
    makerez();

    return 0;
}




