//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
/*---------------------------------------------------------*/
/*   Reads a previously streamed MyDialog Resource         */
/*                                                         */
/*   based on the Turbo Vision HELLO example file          */
/*---------------------------------------------------------*/
#define Uses_TObject
#define Uses_TKeys
#define Uses_TApplication
#define Uses_TEvent
#define Uses_TRect
#define Uses_TDialog
#define Uses_TStaticText
#define Uses_TButton
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_MsgBox
#define Uses_TStreamableClass
#define Uses_TResourceCollection
#define Uses_TResourceFile


#define Uses_fpstream





#include <tv.h>
__link(RWindow);
__link(RGroup);
__link(RDialog);
__link(RFrame);
__link(RResourceCollection);
__link(RButton);
__link(RCluster);
__link(RStaticText);

#include <string.h>
#include <stdlib.h>

const GreetThemCmd = 100;
const char rezFileName[] = "MY.REZ";



/*==================START MyDialog Functions ===============================*/
class MyDialog: public TDialog
{
  virtual const char* streamableName() const
  {
   return "MyDialog";
   }
 protected:
  virtual void *read( ipstream& );
  virtual void write( opstream& );
  MyDialog(  StreamableInit s):TDialog(streamableInit),
	     TWindowInit( &MyDialog::initFrame ){};
 public:
 static const char* const name;
 static TStreamable* build();
 MyDialog(TRect& r, char* str ):TDialog( r, str ),
	 TWindowInit( &MyDialog::initFrame ){};
 virtual void handleEvent( TEvent& event );
 };

const char* const MyDialog::name = "MyDialog";


void* MyDialog::read( ipstream& is )
{
 TDialog::read( is );
 return this;
}
TStreamable* MyDialog::build()
 {
  return new MyDialog( streamableInit );
  }

void MyDialog::write( opstream& os)
{
  TDialog::write( os );
}

TStreamableClass RMyDialog( MyDialog::name,
			      MyDialog::build,
			      __DELTA(MyDialog)
			      );



void MyDialog::handleEvent(TEvent& event)
{
    if( event.what == evCommand )
	{
	switch( event.message.command )
	    {
	    default:
		break;
	}
    }
  // pass on the event...
  TDialog::handleEvent(event);
}
/*======================END MyDialog Functions =============================*/




/*======================START THelloApp Functions ==========================*/
class THelloApp : public TApplication
{

public:
    THelloApp();

    virtual void handleEvent( TEvent& event );
    static TMenuBar *initMenuBar( TRect );
    static TStatusLine *initStatusLine( TRect );

private:

    void greetingBox();
};

THelloApp::THelloApp() :
    TProgInit( &THelloApp::initStatusLine,
	       &THelloApp::initMenuBar,
	       &THelloApp::initDeskTop
	     )
{
}

void THelloApp::greetingBox()
{
   TDialog *d;
   fpstream *ofps=0;
   ofps = new fpstream( rezFileName, ios::in|ios::binary );
   if( !ofps->good() )
     messageBox("Stream open error", mfError|mfOKButton );

   TResourceFile *myRez;
   myRez = new TResourceFile( ofps );

   if( !myRez )
     messageBox("Resource file error", mfError|mfOKButton );
   else
     d = (TDialog*)myRez->get("Zebra");

   if( !d )// if "getting" resource failed...
     messageBox("Get resource error", mfError|mfOKButton );
   else
    deskTop->execView( d );
}

void THelloApp::handleEvent( TEvent& event )
{
    TApplication::handleEvent( event );
    if( event.what == evCommand )
	{
	switch( event.message.command )
	    {
	    case GreetThemCmd:
		greetingBox();
		clearEvent( event );
		break;
	    default:
		break;
	    }
	}
}

TMenuBar *THelloApp::initMenuBar( TRect r )
{

    r.b.y = r.a.y+1;

    return new TMenuBar( r,
      *new TSubMenu( "~H~ello", kbAltH ) +
	*new TMenuItem( "~G~reeting...", GreetThemCmd, kbAltG ) +
	 newLine() +
	*new TMenuItem( "E~x~it", cmQuit, cmQuit, hcNoContext, "Alt-X" )
	);

}

TStatusLine *THelloApp::initStatusLine( TRect r )
{
    r.a.y = r.b.y-1;
    return new TStatusLine( r,
	*new TStatusDef( 0, 0xFFFF ) +
	    *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
	    *new TStatusItem( 0, kbF10, cmMenu )
	    );
}
/*======================END THellopApp Functions ===========================*/




int main()
{
    THelloApp helloWorld;
    helloWorld.run();
    return 0;
}
