// ObjectWindows - (C) Copyright 1992 by Borland International
// File: DIALTEST.CPP
/*
   This is a modifed DIALTEST ( from owl\examples ) that demonstrates
   showing and hiding child windows (dialogs ) and posting messages
   to other windows ( in this case the child dialog responds to a
   button ( show other ) and posts a message to the parent. The parent
   responds to these messages by showing and hiding the child windows
*/
#include <owl.h>
#include <dialog.h>
#include "dialtest.h"
BOOL Dialog1Showing = FALSE;
class TTestDialog : public TDialog
{

public:
  TTestDialog(PTWindowsObject AParent, LPSTR AName)
    : TDialog(AParent, AName)
    {

    };
  virtual void HandleButtonMsg(RTMessage Msg)
    = [ID_FIRST + ID_BUTTON];
  virtual void HandleListBoxMsg(RTMessage Msg)
    = [ID_FIRST + ID_LISTBOX];
  virtual void ShowOtherDialog(RTMessage Msg)
    = [ID_FIRST + ID_OTHERDLG];
  virtual void Cancel( RTMessage Msg )
  {
   // add code to handle cleanup if user cancels the Dialog and
   // then wants to start again from Main Window
   Dialog1Showing = FALSE;
   TDialog::Cancel( Msg );
  }
};

class TTestWindow : public TWindow
{
 PTDialog ptrDlg1;
 PTDialog ptrDlg2;
public:
  TTestWindow(PTWindowsObject AParent, LPSTR ATitle);
  virtual void CMTest(RTMessage Msg)
    = [CM_FIRST + CM_TEST];
virtual void WMDlg1(RTMessage Msg)
    = [WM_FIRST + WM_DLG1];
virtual void WMDlg2(RTMessage Msg)
    = [WM_FIRST + WM_DLG2];
virtual void SetupWindow();
};





class TTestApp : public TApplication
{
public:
  TTestApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow) :
    TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};



void TTestDialog::ShowOtherDialog(RTMessage)
{
//  CloseWindow();
 
 if( Dialog1Showing )
 {
  PostMessage( Parent->HWindow, WM_FIRST+WM_DLG2, 0, 0L );
  Dialog1Showing = FALSE;
 }
 else
 {
  PostMessage( Parent->HWindow, WM_FIRST+WM_DLG1, 0, 0L );
  Dialog1Showing = TRUE;
 }
}

void TTestDialog::HandleButtonMsg(RTMessage)
{
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 1");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 2");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 3");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 4");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 5");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 6");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 7");
}

void TTestDialog::HandleListBoxMsg(RTMessage Msg)
{
  DWORD Idx;
  char SelectedText[10];

  if ( Msg.LP.Hi == LBN_SELCHANGE )
  {
    Idx = SendDlgItemMsg(ID_LISTBOX, LB_GETCURSEL, 0, 0L);
    SendDlgItemMsg(ID_LISTBOX, LB_GETTEXT, (WORD)Idx, (DWORD)SelectedText);
    MessageBox(HWindow, SelectedText, "You selected", MB_OK);
  }
}

TTestWindow::TTestWindow(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu("COMMANDS");
  ptrDlg1= new TTestDialog(this, "TESTDIALOG");
  ptrDlg2= new TTestDialog(this, "TESTDIALOG");
  GetApplication()->MakeWindow(ptrDlg1);
  GetApplication()->MakeWindow(ptrDlg2);

}
void TTestWindow::SetupWindow()
{
 TWindow::SetupWindow();
 MoveWindow( ptrDlg2->HWindow, 150, 100, 400, 215 , 0);
 ShowWindow( ptrDlg1->HWindow, SW_HIDE );
 ShowWindow( ptrDlg2->HWindow, SW_HIDE );

}
void TTestWindow::CMTest(RTMessage)
{
 if( !Dialog1Showing )
 {
  ShowWindow( ptrDlg1->HWindow, SW_SHOW );
  Dialog1Showing = TRUE;
  ShowWindow( ptrDlg2->HWindow, SW_HIDE );
 }
}

void TTestWindow::WMDlg1(RTMessage)
// shows Dialog1, hides dialog2
{
 ShowWindow( ptrDlg1->HWindow, SW_SHOW );
 ShowWindow( ptrDlg2->HWindow, SW_HIDE );
}
void TTestWindow::WMDlg2(RTMessage)
// shows Dialog2, hides dialog1
{
 ShowWindow( ptrDlg2->HWindow, SW_SHOW );
 ShowWindow( ptrDlg1->HWindow, SW_HIDE );
}

void TTestApp::InitMainWindow()
{
  MainWindow = new TTestWindow(NULL, Name);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TTestApp TestApp("Dialog Tester", hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  TestApp.Run();
  return (TestApp.Status);
}

