#include <iostream.h>
#include <conio.h>

#define Uses_otstream
#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TRect
#define Uses_TTerminal
#define Uses_TWindow

#include <tv.h>

//------------------------------------------------------------------------
class TOutputWindow : public TWindow
    {
    TTerminal *term;

public:
    TOutputWindow( TRect bounds, const char *title,
                ostream_withassign& ostr, ushort bufsize );
    void attach( ostream_withassign& ostr );
    };

//------------------------------------------------------------------------
class TOutErr : public TApplication
    {
    ostream_withassign oldCout;
    ostream_withassign oldCerr;
    ostream_withassign oldClog;

public:
    TOutErr( TRect& outbounds, ushort outBufSize,
                TRect& errBounds, ushort errBufSize );
    ~TOutErr();
    virtual void run();
    };

TOutputWindow::TOutputWindow( TRect bounds, const char *title,
            ostream_withassign& ostr, ushort bufsize ) :
            TWindowInit( TOutputWindow::initFrame ),
            TWindow( bounds, title, wnNoNumber )
    {
    bounds = getExtent();
    term = new TTerminal( bounds,
                standardScrollBar( sbHorizontal | sbHandleKeyboard ),
                standardScrollBar( sbVertical | sbHandleKeyboard ),
                bufsize );
    insert( term );
    otstream ot( term );
    ot << "Terminal window \"" << title << "\" created. " << endl;
    ostr = ot;
    }

//------------------------------------------------------------------------
void TOutputWindow::attach( ostream_withassign& ostr )
    {
    ostr = term;
    }

//------------------------------------------------------------------------
TOutErr::TOutErr( TRect& outbounds, ushort outBufSize,
            TRect& errBounds, ushort errBufSize ) :
            TProgInit( TOutErr::initStatusLine, TOutErr::initMenuBar,
            TOutErr::initDeskTop )
    {
    oldCout = cout;
    oldCerr = cerr;
    oldClog = clog;
    TOutputWindow *tow;
    tow = new TOutputWindow( outbounds, "Standard Output", cout, outBufSize );
    deskTop->insert( tow );
    tow = new TOutputWindow( errBounds, "Standard Error", cerr, errBufSize );
    tow->attach( clog );
    deskTop->insert( tow );
    }

//------------------------------------------------------------------------
TOutErr::~TOutErr()
    {
    cout = oldCout;
    cerr = oldCerr;
    clog = oldClog;
    }

//------------------------------------------------------------------------
void TOutErr::run()
    {
    cout << "Testing standard output:";
    for( int i=0; i<10; i++ )
        cout << ' ' << i;
    cout << endl;

    cerr << "Testing standard error:";
    for( i=0; i<20; i++ )
        cerr << ' ' << i;
    cerr << endl;
    
    clog << "Testing log:";
    for( i=0; i<30; i++ )
        clog << ' ' << i;
    clog << endl;
    
    TApplication::run();
    }

//------------------------------------------------------------------------
int main( int argc, char **argv )
    {
    cout << "Testing " << argv[0] << "\n\n   Press any key...";
    getch();
    TOutErr outerr( TRect( 0, 0, 80, 15 ),
                8192, TRect( 0, 15, 80, 23 ), 2048 );
    outerr.run();
    return argc;
    }

