// *************************************************************** //
// Filename:    fdynarr.h                                          //
//                                                                 //
// Date:        June 28, 1993                                      //
//                                                                 //
// Description:                                                    //
//    dynamic array                                                //
//                                                                 //
// $Lgb$                                                           //
// Tue Jun 29, 1993 07:39 Am   1.0     
// Wed Jun 30, 1993 18:16 Pm   1.1     
// $Lge$                                                           //
// *************************************************************** //

#ifndef DYNARR_H
#define DYNARR_H 1

#include <stdlib.h>
#include <stdio.h>

typedef unsigned int uiNDX;

// --------------------------------------------------------------- //
// dynamic array                                                   //
// --------------------------------------------------------------- //
template <class T>
class fDynArray 
{
private:
   fDynArray(fDynArray &);
   fDynArray& operator=(fDynArray &);
protected:
   uiNDX Size;
   uiNDX Top;
   uiNDX Chase;
   T **array;

   void ReAlloc(int Delta = 10);
   void ClearTop();
   void MakeHoleAt(uiNDX idx);
   void InsertAt(T *t, uiNDX idx);
public:
   fDynArray(uiNDX n=10);
   ~fDynArray();
   T* operator[](uiNDX ui);
   uiNDX GetTop()          { return Top; }
   uiNDX GetSize()         { return Size; }
   uiNDX GetSearchIndex()  { return Chase; }
   int Search(T t);
   void Add(T *t, int duplicate = 1);
   void Delete(uiNDX ui);
};

// --------------------------------------------------------------- //
// Reallocate the array size                                       //
// --------------------------------------------------------------- //
template <class T>
void fDynArray<T>::ReAlloc(int Delta = 10) 
{
   array = (T **) realloc(array, (Size+Delta)*sizeof(T *));
   Size += Delta;
   ClearTop();
}

// --------------------------------------------------------------- //
// Clear from the top to the end of the array                      //
// --------------------------------------------------------------- //
template <class T>
void fDynArray<T>::ClearTop()
{
   for (uiNDX i=Top; i<Size; i++)
      array[i] = NULL;
}

// --------------------------------------------------------------- //
// constructor                                                     //
// --------------------------------------------------------------- //
template <class T>
fDynArray<T>::fDynArray(uiNDX n=10) 
{
   array = (T **) malloc(n * sizeof(T *));
   Size = n;
   Top = 0;
   ClearTop();
}

// --------------------------------------------------------------- //
// destructor                                                      //
// --------------------------------------------------------------- //
template <class T>
fDynArray<T>::~fDynArray() 
{
   uiNDX ul;
   for (ul = 0; ul<Size; ul++)
      if (array[ul])
         delete array[ul];
   free(array);
}

// --------------------------------------------------------------- //
// Retrieve from array                                             //
// --------------------------------------------------------------- //
template <class T>
T* fDynArray<T>::operator[](uiNDX ui)
{
   if (ui < Top)
      return array[ui];
   else
      return (T *)NULL;
}

// --------------------------------------------------------------- //
// binary search for element in sorted array                       //
// returns 1 if found                                              //
//         0 if not                                                //
// chase contains index at which element is found                  //
// --------------------------------------------------------------- //
template <class T>
int fDynArray<T>::Search(T t)
{
   uiNDX Left, Right;

   Chase = 0;
   if (Top == 0)
      return 0;
   Left = 0;
   Right = Top-1;
   while (Right - Left > 1) 
   {
      Chase = Left + (Right-Left)/2;
      if (*array[Chase] == t)
         return 1;
      else if (*array[Chase] < t)
         Left = ++Chase;
      else
         Right = --Chase;
   }
   if (*array[Left] == t) 
   {
      Chase = Left;
      return 1;
   }
   if (*array[Right] == t) 
   {
      Chase = Right;
      return 1;
   }
   if (*array[Right] < t) 
   {
      Chase = Right+1;
      return 0;
   }
   if (*array[Left] < t) 
   {
      Chase = Right;
      return 0;
   }
   Chase = Left;
   return 0;
}

// --------------------------------------------------------------- //
// Make a hole at index for new element                            //
// --------------------------------------------------------------- //
template <class T>
void fDynArray<T>::MakeHoleAt(uiNDX idx) 
{
   for (uiNDX i=Top; i>idx; i--)
      array[i+1] = array[i];
   array[idx+1] = array[idx];
   array[idx] = NULL;
   Top++;
}

// --------------------------------------------------------------- //
// Inserts an element in the array                                 //
// --------------------------------------------------------------- //
template <class T>
void fDynArray<T>::InsertAt(T *t, uiNDX idx) 
{
   if (idx >= Top) 
   {
      array[Top++] = t;
      return;
   }
   MakeHoleAt(idx);
   array[idx] = t;
}

// --------------------------------------------------------------- //
// Add an element to the array (keeping sort)                      //
// extra parameter duplicate determines if duplicates are allowed  //
// --------------------------------------------------------------- //
template <class T>
void fDynArray<T>::Add(T *t, int duplicate = 1) 
{
   if (Size - Top < 3)
      ReAlloc();
   if (Search(*t) && !duplicate)
      return;
   uiNDX ui = GetSearchIndex();
   InsertAt(t, ui);
}

// --------------------------------------------------------------- //
// Delete an element from the array                                //
// --------------------------------------------------------------- //
template <class T>
void fDynArray<T>::Delete(uiNDX ui)
{
   uiNDX uiTemp;

   delete array[ui];
   for (uiTemp = ui; uiTemp < Top-1; uiTemp++)
      array[uiTemp] = array[uiTemp+1];
   Top--;
}

#endif
