// File: DYNMENU.CPP
//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
#include <owl.h>
#include "dynmenu.h"
/*
  Dynamic menu manipulation:
  1) responds to a WM_INITMENUPOPUP to initially disable the second menuitem
  2) When the first menuitem is chosen, the second is then enabled
  3) When the second is chosen, a third command is appended to the popup
*/
// the following globals track commands entered by the user, and
// commands we have appended to the menu    
BOOL command1 = False , command2 = False, command3 = False ;

class TTestWindow : public TWindow
{
 HMENU hMainMenu, hPopup; 
public:
  TTestWindow(PTWindowsObject AParent, LPSTR ATitle);
  virtual void CMBeep1(RTMessage Msg)
    = [CM_FIRST + CM_BEEP1];
  virtual void CMBeep2(RTMessage Msg)
    = [CM_FIRST + CM_BEEP2];
  virtual void CMBeep3(RTMessage Msg)
    = [CM_FIRST + CM_BEEP3];
  virtual void WMInitPopUp( RTMessage Msg )
    = [ WM_FIRST + WM_INITMENUPOPUP ];

};

class TTestApp : public TApplication
{
public:
  TTestApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow) :
    TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};


TTestWindow::TTestWindow(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu("MENU_1");
}
void TTestWindow::WMInitPopUp( RTMessage )
{

 hMainMenu = GetMenu( HWindow );
 hPopup = GetSubMenu( hMainMenu, 0 );
 if( !command1 ) // if user has never entered command1, disable 2
   EnableMenuItem( hPopup, 1, MF_BYPOSITION | MF_GRAYED );
 else
   EnableMenuItem( hPopup, 1, MF_BYPOSITION | MF_ENABLED ); 
 if( command2 && !command3 ) // if the user has entered command2, and
  // command3 hasn't been added yet, append the third commandcommand
 {
  InsertMenu( hPopup, -1, MF_BYPOSITION | MF_STRING, CM_BEEP3, "AddBeep" );
  command3 = True;
 }
}
void TTestWindow::CMBeep1(RTMessage)
{
 command1 = True;
 MessageBeep(-1);

 }
void TTestWindow::CMBeep2(RTMessage)
{
 command2 = True;
 for( int i=0; i<5; i++ )
 MessageBeep(-1);
}
void TTestWindow::CMBeep3(RTMessage)
{
 for( int i=0; i<30 ;i++ )
 MessageBeep(-1);
}
void TTestApp::InitMainWindow()
{
  MainWindow = new TTestWindow(NULL, Name);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TTestApp TestApp("Menu Tester", hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  TestApp.Run();
  return (TestApp.Status);
}
