/*

	eb2.hpp
	7-30-91
	Electronic Book: header for eb2.cpp

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef EB2_HPP
#define EB2_HPP

#ifndef FLEXLIST_CPP
#include <flexlist.hpp>
#endif

#ifndef PCVIDEO_HPP
#include <pcvideo.hpp>
#endif

/*

	The HyperLaunch class is used to keep track of the
	positions of launches within the context of a
	HyperTopic.  It is also used to hilite a selected
	launch when viewing.  The address of the first
	position past the launch's opening delimiter is
	passed to the constructor.  The pointer is copied
	(no suballocated memory here) and the visual length
	of the launch is calculated.

	The HyperLaunch class is stored in a FlexList in the
	HyperContext class which calls hilite() to hilite
	the launch (see	below).

*/

class HyperLaunch  {
	int ix, iy, ilen;
	const char *launch;
	#pragma argsused
	void * operator new(size_t size)
		{ return (void *)0; }
public:
	HyperLaunch(int imageX, int imageY,
		const char *launch);
	#pragma argsused
	void * operator new(size_t size, void * ptr)
		{ return ptr; }
	void hilite(int winleft, int wintop, int winwidth,
		int winheight, int attr);
	int len()  { return ilen; }
	int IX()  { return ix; }
	int IY()  { return iy; }
	int match(const char *prefix, int pfLen);
	int onLaunchPad(int imageX, int imageY)
		{ return (imageY == iy && imageX >= ix
			&& imageX <= ix + ilen - 1); }
};
typedef HyperLaunch * HyperLauncH;
#define HyperLauncH0 ((HyperLauncH)0)



/*

	The HyperContext class views a given context. If a
	launch is choosen by the reader the target is
	determined from outlinks.  Information about the
	launches within the context are stored in
	HyperLaunch instances and are queued into the
	HyperContext's base class FlexList.

*/

#define MAX_HC_PREFIX  21


class HyperContext  {
static  Palette defaultP;
	PalettE P;
	char *context;
	unsigned clen;
	FlexList lines;
	FlexList launches;
	char *inlinks, *outlinks;
	unsigned choice;
	void findLinesAndLaunches();
	unsigned startRow, startColumn;
	unsigned cursorRow, cursorColumn;
	unsigned topicNum;
static  int defaultTabSpacing;
	int tabSpacing;
	char prefix[MAX_HC_PREFIX];
	int pfLen;
public:
	enum HC_PALETTE { COLOR, NORMAL, HILITE, SELECT };
	void setPalette(PalettE P = PalettE0)
		{ this->P = (P? P : defaultP); }
	HyperContext(char *context, unsigned clen,
		const char *inlinks, const char *outlinks,
		unsigned startRow, unsigned startColumn,
		unsigned cursorRow, unsigned cursorColumn,
		unsigned topicNum);
	enum HC_ACTIONS  {
		HELP, LOAD, TABLE_OF_CONTENTS,
		INDEX, LAUNCH, BACKUP, EXIT
	};
	HC_ACTIONS view();
	char * newTarget();  // volatile, save immediately
	unsigned StartColumn()  { return startColumn; }
	unsigned StartRow()  { return startRow; }
	unsigned CursorColumn()  { return cursorColumn; }
	unsigned CursorRow()  { return cursorRow; }
	unsigned TopicNum()  { return topicNum; }
	~HyperContext();
};
typedef HyperContext *HyperContexT;
#define HyperContexT0 ((HyperContexT)0)

#endif

