/*

	eb3.cpp
	7-30-91
	Electronic Book


	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList may use and modify this
	tool for use in their programs.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233


	Notes:  The Electronic Book was coded to demonstrate
	the various uses of FlexList.


*/

#include <eb3.hpp>

HyperTopic::HyperTopic(ifstream& f)
{
	char buf[MAX_HYPER_LINE];

	inlinks = outlinks = (char *)0;
	contextLength = 0;
	for (long epos = fpos = f.tellg();
		f.getline(buf,MAX_HYPER_LINE);
		epos = f.tellg())
		if (!inlinks)  {
			inlinks = extractLinksDup(buf,1);
			if (inlinks)
				fpos = f.tellg();
		}
		else  {
			outlinks = extractLinksDup(buf,0);
			if (outlinks)  {
				contextLength = epos - fpos;
				break;
			}
		}
	if (inlinks && !outlinks)  {
		delete inlinks;
		inlinks = (char *)0;
	}
}

int HyperTopic::match(HyperTextTargeT HTT,
	unsigned topicNum)
{
	if (!HTT) return 0;
	if (HTT->Topic())  {
		if (strcmpi(HTT->Topic(),parseLinks(inlinks)))
			return 0;
	}
	else if (topicNum > 1)
		return 0;
	return 1;
}

HyperContexT HyperTopic::fetch(HyperTextTargeT HTT,
	unsigned topicNum)
{
	if (!match(HTT,topicNum) || !contextLength)
		return HyperContexT0;
	ifstream f(HTT->Fname(),ios::in|ios::binary);
	if (!f)
		return HyperContexT0;
	if (!f.seekg(fpos))
		return HyperContexT0;
	char * c;
	if ((c = new char [contextLength+1]) == (char *)0) {
		f.close();
		return HyperContexT0;
	}
	f.read(c,contextLength);
	if (f.fail())  {
		f.close();
		delete c;
		return HyperContexT0;
	}
	c[contextLength] = '\0';
	HyperContexT HC = new HyperContext(c,contextLength,
		inlinks,outlinks,HTT->StartRow(),
		HTT->StartColumn(),HTT->CursorRow(),
		HTT->CursorColumn(),topicNum);
	if (!HC)
		delete c;
	return HC;
}

char * PickIndex::choice()
{
	char * C;
	if ((C = (char *)PickListWindow::choice())
		== (char *)0) return (char *)0;
	for (int i = 0; C[i]; i++)
		if (C[i] == HYPER_LINKS_DELIMIT)
			if (C[++i])
				return &C[i];
			else
				return (char *)0;
	if (i)
		return C;
	return (char *)0;
}

int   HyperFile::FNdestruct(void *ND, void *D)
{
	HyperTopiC HT = (HyperTopiC) ND;
	if (D) return 0;
	HT->HyperTopic::~HyperTopic();
	return 1;
}

HyperFile::HyperFile(const char *fname)
	: FlexList(FLvariantData)
{
	void * getter = &getter;

	refs = 0;
	this->fname[0] = '\0';
	ifstream f(fname);
	if (!f)
		return;
	HyperTopiC HT;
	while (!f.eof())
		if ((HT = new(insQD(getter)) HyperTopic(f))
			== HyperTopiC0)
			break;
		else if (!HT->ConstructOK()) {
			mkcur(Nodes());
			delD();
			break;
		}
	if (f.bad())
		clear();
	else
		strcpy(this->fname,fname);
	f.close();
	return;
}

int HyperFile::match(HyperTextTargeT HTT)
{
	if (!HTT) return 0;
	if (strcmpi(fname,HTT->Fname()))
		return 0;
	return 1;
}

HyperContexT HyperFile::fetch(HyperTextTargeT HTT)
{
	HyperTopiC HT;
	HyperContexT HC;

	if (!match(HTT))
		return HyperContexT0;
	mkcur();
	while ((HT = (HyperTopiC) nextD()) != HyperTopiC0)
		if (HT->match(HTT,CurNum()))
			if ((HC = HT->fetch(HTT,CurNum()))
				== HyperContexT0)
				return HyperContexT0;
			else  {
				refs++;
				return HC;
			}
	return HyperContexT0;
}

int HyperFile::discard(const char *fname)
{

	if (strcmpi(fname,this->fname))
		return -1;	// not this file
	if (--refs > 0)
		return 1;	// other links exist
	return 0;		// ok to discard
}

PickTOC HyperFile::TableOfContents(const char *fname)
{
	if (strcmpi(fname,this->fname))
		return PickL0;	// not this file

	PickTOC TOC = new PickTableOfContents;

	if (TOC)  {
		mkcur();
		HyperTopiC HT;
		while ((HT = (HyperTopiC) nextD())
			!= HyperTopiC0)
			TOC->addT(HT->topic());

	}
	return TOC;
}

PickIDX HyperFile::Index(const char *fname)
{
	if (strcmpi(fname,this->fname))
		return PickL0;	// not this file

	PickIDX IDX = new PickIndex;

	if (IDX)  {
		mkcur();
		HyperTopiC HT;
		while ((HT = (HyperTopiC) nextD())
			!= HyperTopiC0)
			if (IDX->addT(HT->topic()))
				while (IDX->addC(HT->clue()))
					/* null stmt */;
	}
	return IDX;
}

int   HyperServer::FNdestruct(void *ND, void *D)
{
	HyperFilE HF = (HyperFilE) ND;
	if (D) return 0;
	HF->HyperFile::~HyperFile();
	return 1;
}


HyperContexT HyperServer::fetch(HyperTextTargeT HTT)
{
	HyperFilE HF;
	HyperContexT HC;

	if (!HTT)
		return HyperContexT0;

	// Look to see is file is already loaded.
	mkcur();
	while ((HF = (HyperFilE) nextD()) != HyperFilE0)
		if (HF->match(HTT))
			return HF->fetch(HTT);

	// File isn't in memory, load it!

	void * getter = &getter;

	if ((HF = new (insQD(getter))
		HyperFile(HTT->Fname())) != HyperFilE0)
		if (HF->ConstructOK())
			return HF->fetch(HTT);
		else  {
			mkcur(Nodes());
			delD();
		}
	return HyperContexT0;
}


void HyperServer::discard(const char *fname)
{
	if (!fname) return;

	mkcur();
	HyperFilE HF;
	while ((HF = (HyperFilE) nextD()) !=  HyperFilE0)
		switch (HF->discard(fname))  {
		case 1:
			return;  // other links exist
		case 0:
			delD();
			return;
		case -1:
		default:	// not this file
			break;
		}
}

PickTOC HyperServer::TableOfContents(const char *fname)
{
	if (!fname) return PickL0;

	mkcur();
	HyperFilE HF;
	PickTOC TOC = PickTOC0;
	while ((HF = (HyperFilE) nextD()) != HyperFilE0)
		if ((TOC = HF->TableOfContents(fname))
			!= PickTOC0)
			break;
	return TOC;
}

PickIDX HyperServer::Index(const char *fname)
{
	if (!fname) return PickIDX0;

	mkcur();
	HyperFilE HF;
	PickIDX IDX = PickIDX0;
	while ((HF = (HyperFilE) nextD()) != HyperFilE0)
		if ((IDX = HF->Index(fname))
			!= PickIDX0)
			break;
	return IDX;
}
