/*

	pcframe.hpp
	7-30-91
	Text mode framing for the IBM PC.

	Copyright 1991
	John W. Small
	All right reserved
	Use freely but acknowledge authorship and copyright.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef PCFRAME_HPP
#define PCFRAME_HPP

#include <conio.h>

class TextFraming  {
	static unsigned char frame[];
	static int buf[];
	static struct text_info ti;
	int puttext(int l, int t, int r, int b, void *buf);
	// keep ::puttext() from crashing on bad dimensions.
public:
	enum LSTYLE { SINGLE, DOUBLE, LSTYLES };
	enum LDIR { VERTICAL, HORIZONAL, LDIRS };
	enum BSTYLE { SVSH, DVDH, SVDH,
		DVSH, BSTYLES };
	enum BCHAR { VERT, HORIZ, UPPER_LEFT,
		MIDDLE_TOP, UPPER_RIGHT,
		MIDDLE_RIGHT, LOWER_RIGHT,
		MIDDLE_BOTTOM, LOWER_LEFT,
		MIDDLE_LEFT, CROSS, BCHARS };
	void reset()  { gettextinfo(&ti); }
	// Call reset after every textmode change!
	TextFraming() { reset(); }
	int validDimensions(int left, int top, int right,
		int bottom);
	int validateDimensions(int& left, int& top,
		int& right, int& bottom,
		unsigned minWidth, unsigned minHeight);
	unsigned char lnChar(enum LSTYLE ls,
		enum LDIR ld)	{ return
		frame[ls*BCHARS+ld]; }
	unsigned char bxChar(enum BSTYLE bs,
		enum BCHAR bc) { return
		frame[bs*BCHARS+bc]; }
	void vline(int x, int top, int bottom, int attr,
		enum LSTYLE ls);
	void hline(int y, int left, int right, int attr,
		enum LSTYLE ls);
	void box(int left, int top, int right, int bottom,
		int attr, enum BSTYLE bs);
};

extern TextFraming PCF;

typedef TextFraming TxtFrmg;

#define NO_FRAME	TxtFrmg::BSTYLES
#define SINGLE_FRAME	TxtFrmg::SVSH
#define DOUBLE_FRAME	TxtFrmg::DVDH
#define MAX_TF_BUF	132


#endif
