/*

	pcput2.cpp
	7-30-91
	Write two color text strings

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#include <pcput2.hpp>

int ScrLnBuf::buf[MAX_SCR_LN_BUF];

void ScrLnBuf::set(int normattr, int highattr,
	unsigned pgWidth, unsigned startColumn, int clreol,
	char lineTermChar, char attrToggleChar,
	unsigned tabSpacing)
{
	this->normattr        =  normattr;
	this->highattr        =  highattr;
	if (pgWidth > MAX_SCR_LN_BUF)
		this->pgWidth = MAX_SCR_LN_BUF;
	else
		this->pgWidth = pgWidth;
	this->startColumn     =  startColumn;
	this->clreol          =  clreol;
	this->lineTermChar    =  lineTermChar;
	this->tabSpacing      =  tabSpacing;
	this->attrToggleChar  =  attrToggleChar;
	eolColumn             =  1;
	lidx                  =  0;
}

int ScrLnBuf::writebuf(const char *line)
{
	int toggle = 0;
	int attr = (normattr << 8);
	int bidx = 0;
	eolColumn = 1;
	if (line) for (lidx = 0; bidx < pgWidth &&
		line[lidx] && line[lidx] != lineTermChar;
		lidx++)
		if (line[lidx] == attrToggleChar)
			if (line[lidx+1] == attrToggleChar)  {
				lidx++;
				if (eolColumn++ >= startColumn)
					buf[bidx++] = attr |
					(unsigned char)
					attrToggleChar;
			}
			else
				if (++toggle % 2)
					attr = (highattr << 8);
				else
					attr = (normattr << 8);
		else if (line[lidx] == '\t')
			do {
				if (eolColumn >= startColumn)
					buf[bidx++] = attr |
					(unsigned char) ' ';
			} while (eolColumn++ % tabSpacing);
		else  if (eolColumn++ >= startColumn)
				buf[bidx++] = attr |
				(unsigned char) line[lidx];
	if (bidx < pgWidth && clreol)  {
		attr |= (unsigned char) ' ';
		while (bidx < pgWidth)
			buf[bidx++] = attr;
	}
	return bidx;
}

