//
// Having a button end the modal state...
//
// Written by Borland C++ Tech Support
//

#define Uses_TKeys
#define Uses_TRect
#define Uses_TEvent
#define Uses_TLabel
#define Uses_TButton
#define Uses_TInputLine
#define Uses_TDialog
#define Uses_TMenuBar
#define Uses_TMenu
#define Uses_TMenuItem
#define Uses_TStaticText
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TDeskTop
#define Uses_TApplication
#include <tv.h>

#include <stdio.h>

const int cmModalBox    = 100;          // Command list.
const int cmOne         = 101;
const int cmTwo         = 102;


class TMode : public TApplication
{
public:
    TMode() : TProgInit( initStatusLine, initMenuBar, initDeskTop) { }
    virtual void handleEvent( TEvent& event );
    static TMenuBar *initMenuBar( TRect r );

    void createModalBox( void );
};


class TModalBox : public TDialog
{
public:
    TModalBox();
    virtual void handleEvent( TEvent& event );
};


class TEntryBox : public TDialog
{
public:
    TEntryBox( char *labels[] );

    struct TEBData
    {
        char lineOne[25];
        char lineTwo[25];
    };
};


//
// Junk names for test purposes...
//
char *names[][3] = {
    { "Dialog box #1", "Velocity", "Acceleration" },
    { "Dialog box #2", "Force", "Impulse" }
};


//
// Code for main() function.
//

void main(void)
{
    TMode modalApp;
    modalApp.run();
}


//
// Code for the TMode object (Application object.)
//

TMenuBar *TMode::initMenuBar( TRect r )
{
    r.b.y =  r.a.y + 1;

    return (new TMenuBar( r, new TMenu(
      *new TMenuItem( "~M~odal Dialog", cmModalBox, kbAltM )
      )));
}


void TMode::handleEvent( TEvent& event )
{
    TApplication::handleEvent(event);

    if (event.what == evCommand)
    {
        switch (event.message.command)
        {
        case cmModalBox:
            createModalBox();
            clearEvent(event);
            break;
        }
    }
}


void TMode::createModalBox()
{
    TView *t;
    ushort cmr;

    t = (TView *) validView( new TModalBox );
    if( t )
    {
        cmr = deskTop->execView( t );

        if( cmr >= cmOne && cmr <= cmTwo )
        {
            TEntryBox *u = (TEntryBox *) validView(
              new TEntryBox(names[cmr-cmOne])
              );
            TEntryBox::TEBData data;

            if( u )
            {
                if(deskTop->execView( u ) == cmOK )
                    u->getData( &data );
            }
        }
    }
    destroy( t );
}


//
// Code for the TModalBox object.
//

TModalBox::TModalBox() :
    TDialog(TRect(0, 0, 36, 9), "About"),
    TWindowInit( initFrame )
{
    insert(new TStaticText(TRect(3,2,33,3), "\003Modal dialogs & buttons\n \n"));
    insert(new TButton(TRect(6,4,16,6), "~O~ne", cmOne, bfNormal));
    insert(new TButton(TRect(6,6,16,8), "~T~wo", cmTwo, bfNormal));
    insert(new TButton(TRect(18,4,28,6), "~C~ancel", cmCancel, bfDefault));
    options |= ofCentered;
}


void TModalBox::handleEvent( TEvent& event )
{
    TDialog::handleEvent( event );      // call parent handleEvent...

    //
    // If the button was pressed, then end the modal state and return
    // the message generated by the button.
    //
    if( event.what == evCommand &&
        (event.message.command >= cmOne && event.message.command <= cmTwo )
      )
    {
        if( (state & sfModal) != 0 )
        {
            endModal( event.message.command );
            clearEvent( event );
        }
    }
}


//
// Constructor for TEntryBox.
//
//

TEntryBox::TEntryBox( char *labels[] ) :
    TDialog( TRect(0,0,40,11), labels[0] ),
    TWindowInit( initFrame )
{
    TInputLine *ti = new TInputLine( TRect(2,3,30,4), 25 );
    insert( ti );
    insert( new TLabel( TRect(2,2,30,3), labels[1], ti ) );

    ti = new TInputLine( TRect(2,6,30,7), 25 );
    insert( ti );
    insert( new TLabel( TRect(2,5,30,6), labels[2], ti ) );

    insert( new TButton( TRect(8,8,18,10), "O~K~", cmOK, bfDefault ) );
    insert( new TButton( TRect(22,8,32,10), "~C~ancel", cmCancel, bfNormal ) );

    options |= ofCentered;
}
