//
//   Name of program  : EVISION.EXE
//   Version          : 1.0
//   Last modified    : may 17th, 1992
//   Author           : Rmy Gendron
//   What it does     : EasyVision 1.0 demonstration program.
//
//
// ---- Library Header Files -----------------------------------------------

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>


// ---- Global Macros ------------------------------------------------------

#include "evmacros.hpp"


// ---- Header files of External Functions Called --------------------------

#include "assert.hpp"
#include "tdesktop.hpp"
#include "tstatusline.hpp"
#include "tmenubar.hpp"
#include "getkey.hpp"
#include "twindow.hpp"


// ---- Local Prototypes ---------------------------------------------------

void viewfile ( tstatusline huge *slptr ) ;
void demowindow ( tstatusline huge *slptr ) ;
void about ( tstatusline huge *slptr ) ;


// ---- Global Variables ---------------------------------------------------

   char huge *demohelp =                                 // General helptext

   "~TNG SOFT~ proudly presents ~EasyVision 1.0~.\n\n"
   "This is the ~EasyVison~ demonstration program.  EasyVision is a "
   "collection of C++ ~functions~ and ~classes~.  It will provide you with "
   "the tools to easily produce professional looking programs, in a "
   "fraction of the time normaly needed for such elegance and "
   "performance !\n\n\n  All of this demo program was done with "
   "less than 150 lines of real coding !\n\n  EasyVison was created to be "
   "~powerful~, ~reliable~ and ~simple~ to use !  This is not a librairy "
   "where you have to learn 3 billion new commands.  In fact, there are "
   "only ~4 classes~ and ~10 functions~, for a total of roughly 50 commands. "
   "You will routinely use only 15 to 20 of those because of "
   "all the built in default values.\n\n  You will be able to create and "
   "manage full featured ~windows~, complete with ~scrolling input fields~ "
   "and ~push buttons~.  A ~desktop~, a ~statusline~ and a ~menubar~ "
   "will get together to create a fully integrated user interface.\n\n"
   "The ~F1~ key will always display an ~help "
   "window~, and will be available ~everywhere in your program~, without "
   "you having to write a single line of code !  "
   "You don't have to format the help text either. "
   "The built in help function will format the text in the help window "
   "with ~word wrapping~ !\n\n"
   "So, if you would like to take advantage of this library, just read "
   "the manual included in the archive ~EVISION1.ZIP~, and within the "
   "hour you will be on your way to a new standard in ~quality~ and "
   "~ease of use~ with the EasyVison library !\n\n"
   "~STARFLEET COMMAND BBS~ is the home of all of ~TNG SOFT~'s software.  "
   "Give us a call !\n\n(418) 525-6899/4740/6803\n1200/2400 8N1\n"
   "Fidonet address: 1:240/1701\n\n"
   "Rmy Gendron" ;


// ---- Main Function ------------------------------------------------------

void main()
{
   tdesktop    huge *desktop ;                             // Ptr to classes
   tstatusline huge *statusline ;         // You should always use HUGE ptrs
   tmenubar    huge *menubar ;
   int              command ;                                // User command


   desktop = new tdesktop ;                              // Create a desktop
   assert (desktop != NULL,"main",1) ;
   statusline = new tstatusline ;                       // Create statusline
   assert (statusline != NULL,"main",1) ;
   menubar = new tmenubar ;                                // Create menubar
   assert (menubar != NULL,"main",1) ;

   desktop->insert (statusline) ;            // Insert objects in desktop to
   desktop->insert (menubar) ;                 // allow the refresh function
   desktop->open () ;                                     // Display desktop

   statusline->displayleft ("~F1~ Help") ;             // Display statusline

   menubar->sethelp (demohelp) ;                             // Create menus
   menubar->setslptr (statusline) ;         // Match menubar with statusline
   menubar->addmenu ("",'S',"System menu") ;
   menubar->additem ("Redraw desktop  Alt-R",'R',275,
                     "Redraw the screen") ;
   menubar->additem () ;
   menubar->additem ("About...        Alt-A",'A',286,
                     "Show version and copyright informations") ;
   menubar->addmenu ("Demo",'D',"EasyVision demonstrations") ;
   menubar->additem ("View file...  Alt-V",'V',303,"View a text file") ;
   menubar->additem ("Open window   Alt-O",'O',280,"Show an EasyVision window") ;
   menubar->additem () ;
   menubar->additem ("Exit demo     Alt-X",'E',301,"Exit EasyVision demo") ;
   menubar->addmenu ("Examples",'E',"Just an example menu") ;
   menubar->additem ("Dummy off item...  ",'Z',286,
                     "Menu items can be 'offline'") ;
   menubar->additem ("Do nothing item... ",'Y',277,
                     "This is just an example") ;
   menubar->itemsetavail ('E','Z',0) ;

   command = 0 ;
   while (command != 301)                                   // Alt-X to stop
   {
      statusline->displayright ("Welcome to ~EasyVison~ !") ;
      command = getkey (0,demohelp) ;
      command = menubar->trough (command) ;

      if (command == 286) about (statusline) ;
      if (command == 303) viewfile (statusline) ;
      if (command == 280) demowindow (statusline) ;
      if (command == 275) desktop->refresh () ;
   }

                                                                // Demo over
   desktop->close () ;                                     // Restore screen

   delete statusline ;                                     // Delete classes
   delete menubar ;
   delete desktop ;

   return ;
}                                                                // End main


// ---- Function Definitions -----------------------------------------------

void viewfile                                  // View an external text file

( tstatusline huge *slptr )                         // Ptr to the statusline

{
   twindow  huge *winptr ;                         // Ptr to a twindow class
   char     temp[41] ;                                       // To get input
   int      inchar ;                                    // Input from window


   winptr = new twindow ;                                 // Create a window
   assert (winptr != NULL,"viewfile",1) ;

   winptr->winsetpos (8,20) ;                              // Display window
   winptr->winsetsize (9,40) ;
   winptr->winsetcolors (MAGENTA) ;
   winptr->winsettitle ("View File") ;
   winptr->winsethelp (demohelp) ;
   winptr->winsetslptr (slptr) ;
   winptr->winopen () ;
   winptr->winswrite ("Enter path of file to view:",2,1,2) ;

   winptr->fieldsetlengths (40,20) ;             // Get path of file to view
   winptr->fieldsetcolors (BLUE) ;
   winptr->fieldsetftr (3,":\\.") ;
   winptr->fieldcreate (4,10,"","Enter complete path of some text file") ;
   winptr->buttoncreate (6,2,"   Ok",13,"Accept path") ;
   winptr->buttoncreate (6,12,"  Esc",27,"Abort file viewing") ;
   inchar = winptr->wininput () ;
   winptr->fieldgetasw (temp) ;
   winptr->winclose () ;

   if (inchar == 13)                                       // If accept path
   {
      winptr->winsetpos (2,1) ;                         // Open a big window
      winptr->winsetsize (999,999) ;
      winptr->winsetcolors (BLUE) ;
      winptr->winsettitle ("View file") ;
      winptr->winsethelp (demohelp) ;
      winptr->winsetslptr (slptr) ;
      winptr->winopen () ;
      slptr->displayright ("Viewing file...") ;
      winptr->wintextfile (temp) ;
      winptr->winclose () ;
   }

   slptr->displayright () ;
   delete (winptr) ;

   return ;
}                                                           // End view file


// ---- Function Definitions -----------------------------------------------

void demowindow                                        // Play with a window

( tstatusline huge *slptr )                         // Ptr to the statusline

{
   twindow  huge *winptr ;                         // Ptr to a twindow class
   int      inchar ;                                           // User input


   randomize () ;                            // Init random number generator

   winptr = new twindow ;                                 // Create a window
   assert (winptr != NULL,"demowindow",1) ;

   winptr->winsetpos (7,20) ;                              // Display window
   winptr->winsetsize (13,40) ;
   winptr->winsetcolors (BLUE) ;
   winptr->winsettitle ("Demo Window") ;
   winptr->winsethelp (demohelp) ;
   winptr->winsetslptr (slptr) ;
   winptr->winopen () ;
   winptr->winwrite ("Alpha",2,2) ;
   winptr->winwrite ("Numeric",2,20) ;
   winptr->winwrite ("AlphaNumeric",4,2) ;
   winptr->winwrite ("No restrictions",4,20) ;

   winptr->fieldsetlengths (30,15) ;             // Create some input fields
   winptr->fieldsetcolors (GREEN) ;
   winptr->fieldsetftr (1," ") ;
   winptr->fieldcreate (3,2,"Hello there","This field only accepts letters") ;
   winptr->fieldsetftr (2,"") ;
   winptr->fieldcreate (3,20,"1992","This field only accepts digits") ;
   winptr->fieldsetftr (3," ") ;
   winptr->fieldcreate (5,2,"Enterprise NCC 1701 D",
                            "This field accepts letters and digits") ;
   winptr->fieldsetftr (0) ;
   winptr->fieldcreate (5,20,"EasyVision 1.0 by TNG SOFT !",
                             "This field accepts anything") ;

                                                      // Create some buttons

   winptr->buttoncreate (7,2,"  Move",'M',"Randomly move window") ;
   winptr->buttoncreate (7,29,"  Esc",27,"Close window") ;
   winptr->buttoncreate (10,2,"   Up",'U',"Move window up") ;
   winptr->buttoncreate (10,11,"  Down",'D',"Move window down") ;
   winptr->buttoncreate (10,20,"  Left",'L',"Move window Left") ;
   winptr->buttoncreate (10,29," Right",'R',"Move window Right") ;

   inchar = 0 ;
   while (inchar != 27)                                 // Make window alive
   {
      inchar = winptr->wininput () ;
      if (inchar <= 255) inchar = toupper (inchar) ;

      if (inchar == 'U') winptr->winscroll ('U') ;
      if (inchar == 'D') winptr->winscroll ('D') ;
      if (inchar == 'L') winptr->winscroll ('L') ;
      if (inchar == 'R') winptr->winscroll ('R') ;
      if (inchar == 'M') winptr->winmove (2+random(11),1+random(41)) ;
   }

   winptr->winclose () ;
   delete (winptr) ;

   return ;
}                                                          // End demowindow

// ---- Function Definitions -----------------------------------------------

void about                                     // Display info on EasyVision

( tstatusline huge *slptr )                         // Ptr to the statusline

{
   twindow  huge *winptr ;                         // Ptr to a twindow class

   winptr = new twindow ;                                 // Create a window
   assert (winptr != NULL,"about",1) ;

   winptr->winsetpos (5,20) ;                              // Display window
   winptr->winsetsize (15,40) ;
   winptr->winsetcolors (BLUE) ;
   winptr->winsettitle ("About") ;
   winptr->winsethelp (demohelp) ;
   winptr->winsetslptr (slptr) ;
   winptr->winopen () ;
   winptr->winwrite ("EasyVision 1.0",2,1,2) ;
   winptr->winwrite ("The easy to use and powerful",4,1,2) ;
   winptr->winwrite ("text mode interface !",5,1,2) ;
   winptr->winwrite ("Copyright (c) 1992 by",7,1,2) ;
   winptr->winwrite ("TNG SOFT",9,1,2) ;
   winptr->winwrite ("The Next Generation Software",10,1,2) ;

   winptr->buttoncreate (12,16," Enter",13,"Press ~ENTER~ to continue") ;
   (void) winptr->buttoninput () ;

   winptr->winclose () ;
   delete (winptr) ;

   return ;
}                                                               // End about


// ---- End Main Source File -----------------------------------------------
